<?php

App::uses('AppController', 'Controller');

class EvBasketAppController extends AppController {

	/**
	 * beforeFilter - If the basket component has yet to be set up, do so now
	 */
	public function __construct(CakeRequest $Request, CakeResponse $Response) {
		if (empty($this->components['BasketManager'])) {
			$this->components['BasketManager'] = array(
				'className' => 'EvBasket.Basket',
				'Basket' => EvClassRegistry::init('EvBasket.Basket'),
				'BasketItem' => EvClassRegistry::init('EvBasket.BasketItem'),
				'BasketTotal' => EvClassRegistry::init('EvBasket.BasketTotal')
			);
		}

		$this->helpers['Basket'] = array(
			'className' => 'EvBasket.Basket'
		);

		parent::__construct($Request, $Response);
	}
}
