<?php

App::uses('PluginInstallShell', 'shells');
App::uses('File', 'Utility');

class EvBasketInstallShell extends PluginInstallShell {

	public $uses = array(
		'EvTemplates.Template',
		'EvCore.Page'
	);

	/**
	 * call parent run() This will auto run any migrations
	 *
	 * Use the run() method here to insert any content
	 */
	public function run() {
		parent::run();

		$date = date('Y-m-d H:i:s');

		// add all the base temoplates
		$this->Template->save(
			array(
				'Template' => array(
					'name' => 'Basket',
					'template' => 'EvBasket./Templates/Basket/index',
					'helperFunction' => 'N/A',
					'cfDataLabel' => 'Custom Data',
					'model' => 'Page',
					'is_active' => 1,
					'created' => $date,
					'modified' => $date
				)
			)
		);
		$templateIds = $this->Template->find('list', array('callbacks' => false, 'limit' => 1, 'order' => 'Template.id DESC'));
		$templateIds = array_flip($templateIds);

		$this->Page->save(
			array(
				'Page' => array(
					'title' => 'Basket',
					'is_active' => 1,
					'is_protected' => 1,
					'template_id' => $templateIds['Basket'],
					'created' => $date,
					'modified' => $date
				)
			)
		);
		$pageIds = $this->Page->find('list', array('callbacks' => false, 'limit' => 1, 'order' => 'Page.id DESC'));
		$pageIds = array_flip($pageIds);

		// write to the plugin config
		$configContents = '<?php

$config = array(
	\'EvBasket\' => array(
		/**
		 * the content oage id to use as an intro for the basket
		 */
		\'pageId\' => ' . $pageIds['Basket'] . '
	)
);';

		$File = new File(APP . 'Config/Plugin/ev_basket.php', true);
		$File->write($configContents);
	}
}