<h2><?=$data['Page']['title']?></h2>

<?=$data['Page']['body']?>

<?=$this->Flash->render('basket-flash')?>

<?php
	echo $this->Form->create(
		'BasketItem',
		array(
			'url' => $this->Basket->getFormUrl('update')
		)
	);
?>
	<table class="table table-bordered table-striped">
		<thead>
			<tr>
				<th>Item</th>
				<th>Price</th>
				<th>Quantity</th>
				<th>Total</th>
				<th>&nbsp;</th>
			</tr>
		</thead>

		<tbody>
			<?php if (! empty($basket['BasketItem'])): ?>
				<?php foreach ($basket['BasketItem'] as $key => $BasketItem): ?>
					<tr>
						<td>
							<?=$this->Basket->getItemName($BasketItem)?>
						</td>
						<td>
							<?=$this->Number->currency($BasketItem['unit_price'])?>
						</td>
						<td>
							<?=$this->Basket->quantityField($BasketItem)?>
						</td>
						<td>
							<?=$this->Number->currency($BasketItem['row_total'])?>
						</td>
						<td>
							<?=$this->Basket->deleteLink($BasketItem, '<i class="fa fa-times"></i>', array('escape' => false))?>
						</td>
					</tr>
				<?php endforeach; ?>
			<?php else: ?>
				<tr>
					<td colspan="5">
						There are no items in your basket
					</td>
				</tr>
			<?php endif; ?>
		</tbody>

		<tfoot>
			<?php if (! empty($basket['BasketTotal'])): ?>
				<?php foreach ($basket['BasketTotal'] as $key => $BasketTotal): ?>
					<tr>
						<td colspan="3" class="text-right">
							<span style="padding-right: 25px;">
								<?=$BasketTotal['name']?>
							</span>
						</td>
						<td colspan="2">
							<?=$this->Number->currency($BasketTotal['amount'])?>
						</td>
					</tr>
				<?php endforeach; ?>
			<?php endif; ?>
		</tfoot>
	</table>

	<?php
		if (! empty($basket['BasketItem'])):
			echo $this->Form->button(
				'Update',
				array(
					'type' => 'submit'
				)
			);
		endif;
	?>
<?=$this->Form->end()?>
