<?php
App::uses('EvBasketAppModel', 'EvBasket.Model');
App::uses('CakeSession', 'Model/Datasource');
/**
 * Basket Model
 *
 * @property BasketItem $BasketItem
 * @property BasketTotal $BasketTotal
 */
class Basket extends EvBasketAppModel {

	//The Associations below have been created with all possible keys, those that are not needed can be removed

	/**
	 * hasMany associations
	 *
	 * @var array
	 */
	public $hasMany = array(
		'BasketItem' => array(
			'className' => 'EvBasket.BasketItem',
			'dependent' => true,
			'cascade' => true
		),
		'BasketTotal' => array(
			'className' => 'EvBasket.BasketTotal',
			'dependent' => true,
			'cascade' => true
		)
	);

	public $validate = array(
		'hash' => array(
			'unique' => array(
				'rule' => 'isUnique'
			)
		)
	);

	/**
	 * convience method to get the full basket
	 *
	 * @param 	string 	$hash 			The hash identifier
	 * @param 	array 	$itemContain
	 * @return  array|null
	 */
	public function getFullBasket($hash, $itemContain) {
		$currencyId = CakeSession::read('EvCurrency.currencyId');

		$basket = $this->find(
			'first',
			array(
				'conditions' => array(
					'Basket.hash' => $hash,
					'Basket.currency_id' => $currencyId
				),
				'contain' => array(
					'BasketItem' => $itemContain,
					'BasketTotal' => array(
						'order' => 'BasketTotal.is_grand_total ASC, BasketTotal.sequence ASC'
					)
				)
			)
		);
		if (! empty($basket)) {

			if ((bool)strpos(json_encode($itemContain), 'CustomFields') === true && ! empty($basket['BasketItem'])) {
				$CustomField = EvClassRegistry::init('EvCustomFields.CustomFieldData');

				foreach ($basket['BasketItem'] as $key => $item) {
					$basket['BasketItem'][$key] = $CustomField->formatCfArray($item);
				}
			}

			$basket = $this->formatItemsAndTotals($basket);
		}

		return $basket;
	}

	/**
	 * format the items and totlas keys to be more easily accessbile
	 *
	 * @param 	array 	$basket 	The basket array
	 * @return 	array 	$basket 	The formated basket array
	 */
	public function formatItemsAndTotals($basket) {
		$basket['BasketItem'] = Hash::combine(
			$basket['BasketItem'],
			array(
				'%s.%s',
				'{n}.model',
				'{n}.model_id'
			),
			'{n}'
		);

		// calculate tax for each row item
		$basket['BasketItem'] = $this->BasketItem->calculateTax($basket['BasketItem']);

		$basket['BasketTotal'] = Hash::combine(
			$basket['BasketTotal'],
			'{n}.id',
			'{n}'
		);

		return $basket;
	}

	/**
	 * check to see if a basket exists at the given hash
	 *
	 * @param 	string 	$hash 	hash identifier to look for
	 * @return 	bool
	 */
	public function checkExists($hash) {

		$currencyId = CakeSession::read('EvCurrency.currencyId');

		return (bool)$this->find(
			'count',
			array(
				'conditions' => array(
					'Basket.hash' => $hash,
					'Basket.currency_id' => $currencyId
				),
			'	callbacks' => false
			)
		);
	}

	/**
	 * create a basket row with the given hash
	 *
	 * @param 	string 	$hash 	hash identifier to save basket ot
	 * @return 	bool
	 */
	public function createBasket($hash) {
		$currencyId = CakeSession::read('EvCurrency.currencyId');

		$this->clear();
		$result = $this->save(
			array(
				'Basket' => array(
					'hash' => $hash,
					'currency_id' => $currencyId
				)
			)
		);

		if ($result !== false) {
			return true;
		}

		return $result;
	}
}
