<?php

App::uses('CakeEventListener', 'Event');

class EvBasketCheckForDiscountListener implements CakeEventListener {

	public function implementedEvents() {
		return array(
			'EvDiscount.Component.DiscountCodes.codeAdded' => 'addDiscount',
			'EvBasket.Component.Basket.itemAdd' => 'rebuildDiscount',
			'EvBasket.Component.Basket.itemUpdated' => 'rebuildDiscount',
			'EvBasket.Component.Basket.itemDeleted' => 'rebuildDiscount',

			'EvLoyaltyPoints.Component.Points.usePoints' => 'addLoyaltyDiscount',
		);
	}

	/**
	 * queue up the confirmation emails
	 *
	 * @param 	CakeEvent
	 */
	public function addDiscount(CakeEvent $Event) {
		// Event subject will be the EvDiscount.DiscountCodesComponent
		return $this->rebuildDiscount($Event);
	}

	/**
	 * rebuild discount due to basket amends
	 *
	 * @param 	CakeEvent
	 */
	public function rebuildDiscount(CakeEvent $Event) {
		if (! CakePlugin::loaded('EvDiscount')) {
			return;
		}

		App::uses('DiscountLib', 'EvDiscount.Lib');


		$EventSubject = $Event->subject();
		$EventSubject->_controller->loadModel('EvDiscount.DiscountCode');
		if (! is_object($EventSubject->_controller->DiscountCookie)) {
			$EventSubject->_controller->DiscountCookie = $EventSubject->_controller->loadComponent('EvDiscount.DiscountCookie');
		}

		// try to read the cookies
		$cookie = $EventSubject->_controller->DiscountCookie->read('Code');
		$codeCookie = array();
		if (! empty($cookie)) {
			foreach ($cookie as $key => $value) {
				$codeData = $EventSubject->_controller->DiscountCode->decryptHash($value);
				$codeCookie[$codeData['code']] = $value;
			}
		}

		 // No idea why it was done this way, but the cookie can actualy store more than one discount
		 // code.

		if (! is_object($EventSubject->_controller->BasketManager)) {
			$EventSubject->_controller->BasketManager = $EventSubject->_controller->loadComponent('EvBasket.BasketManager');
		}

		if (! empty($codeCookie) && is_array($codeCookie)) {

			$validCodes = $EventSubject->_controller->DiscountCode->validateCodes($codeCookie);

			if (! empty($validCodes)) {
				// Discount codes were found - now check to see if any of them have any restrictions that need checking.
				//
				// If a coupon has restrictions, the discount plugin cant handle it - its going to need to be handed off
				// to whatever is creating the restriction (i.e you've edited the config file to set what model you're
				// restricting on, so you now need to create an event to handle that restriction as its not possible for the
				// discount plugin to do it).
				//
				// This gets complicated as hell because of how it was written, but the theory behind it is to prevent you
				// ever needing to touch the discount plugin.
				//
				// The problem now comes that because you hand off to another event listener, you then need to completely
				// skip everything else that the discount plugin does, which seems stupid but unless someones got a better
				// way of doing this whilst retaining the flexability of not being restricted to using one shop plugin it's
				// the only way.
				//
				// So, the below code - it sends a copy of the discount code and the basket to an event.
				//
				// What gets returned is a modified basket, with the price reduced on whatever basket item(s) the discount
				// applied to. This is pretty restrictive as you then have no idea what discount was applied where. There's
				// curently nothing that can be done about this as there was no provision made to store discount information
				// on an order other than the total discount amount.
				foreach ($validCodes as $code => $codeData) {
					if (isset($codeData['CodeRestriction']) && ! empty($codeData['CodeRestriction'])) {
						// This code has restrictions that need checking
						$discount = new CakeEvent('EvBasket.Component.Basket.CheckDiscountRestrictions', $EventSubject->_controller, array(
							'discount' => $codeData,
							'basket' => $EventSubject->_controller->BasketManager->getBasket()
						));
						$EventSubject->_controller->getEventManager()->dispatch($discount);

						$results = $discount->result;

						if (! empty($results) && is_array($results)) {
							$EventSubject->_controller->BasketManager->updateItem($results, null, null, 0, false);
						}

						// Remove this discount from the list as it cant be handled down below now.
						unset($validCodes[$code]);
					}
				}
			}

		}
		$total = $EventSubject->_controller->BasketManager->findTotalRow(
			Configure::read('EvBasket.labels.subtotal')
		);

		$discount = 0;
		if (! empty($validCodes) && is_array($validCodes)) {
			foreach ($validCodes as $codeData) {
				if (
					! empty($codeData['DiscountCode']['min_order']) &&
					$total['amount'] < $codeData['DiscountCode']['min_order']
				) {
					continue;
				}

				$amount = DiscountLib::calculate($codeData, $total['amount']);
				if (! empty($amount)) {
					$discount += $amount;
				}
			}
		}

		if (! empty($discount) && $discount > 0) {
			$EventSubject->_controller->BasketManager->manageTotalRow(
				Configure::read('EvBasket.labels.discount'),
				-$discount,
				15
			);

			$Event->subject()->_controller->BasketManager->rebuildTotals();
		}

		return true;
	}

	public function addLoyaltyDiscount(CakeEvent $Event) {
		if (! CakePlugin::loaded('EvLoyaltyPoints')) {
			return false;
		}
		$EventSubject = $Event->subject();

		if (! is_object($EventSubject->_controller->BasketManager)) {
			$EventSubject->_controller->BasketManager = $EventSubject->_controller->loadComponent('EvBasket.BasketManager');
		}

		$total = $EventSubject->_controller->BasketManager->findTotalRow(
			Configure::read('EvBasket.labels.subtotal')
		);

		App::uses('PointLib', 'EvLoyaltyPoints.Lib');

		$discount = PointLib::calculate($total['amount'], 'EvBasket');

		if (! empty($discount) && $discount > 0) {
			$EventSubject->_controller->BasketManager->manageTotalRow(
				Configure::read('EvBasket.labels.discount'),
				-$discount,
				15
			);

			$Event->subject()->_controller->BasketManager->rebuildTotals();
		}

		return true;
	}
}
