<?php

App::uses('CakeEventListener', 'Event');
App::uses('CakeLog', 'Log');
class EvBasketCheckForCurrencyChangeListener implements CakeEventListener {

	public function implementedEvents() {
		return array(
			'EvCurrency.Component.Currencies.setCurrency' => 'currencyChange'
		);
	}

	/**
	 * handle currency switching
	 *
	 * @param 	CakeEvent
	 */
	public function currencyChange(CakeEvent $Event) {
		// Once a currency change happens, the basket is no longer used.
		$Event->subject()->_controller->BasketCookie->delete('basketHash');
		$Event->subject()->_controller->BasketManager->resetBasket();

		$hash = $Event->subject()->_controller->BasketManager->setupHash();
		$Event->subject()->_controller->BasketManager->setupBasket($hash);

		return true;
	}
}
