<?php

App::uses('EvBasketAppController', 'EvBasket.Controller');

class BasketController extends EvBasketAppController {

	public function beforeFilter() {
		parent::beforeFilter();

		$this->Auth->allow(
			array(
				'index',
				'add',
				'remove',
				'update',
				'test'
			)
		);
	}

	public function test() {
	}

	/**
	 * main basket page
	 *
	 */
	public function index() {
		$this->view = 'EvBasket./Fallbacks/Basket/index';

		$pageId = Configure::read('EvBasket.pageId');

		// check if we have a specific content page set
		// if so - set the template
		if (! empty($pageId)) {
			$pageData = $this->assignPage($pageId);

			if (! empty($pageData)) {
				$this->view = $this->Tpl->getTemplate($pageData, 'Page');
			}
		}

		$this->set(
			'basket',
			$this->BasketManager->getBasket()
		);
	}

	/**
	 * delete an item from your basket (if valid)
	 * and redirect back to previous page
	 */
	public function remove($id) {
		// given the BasketItem row ID and find the model data
		$basketItem = $this->BasketManager->getBasketItem($id);

		$itemData = array(
			'model' => $basketItem['model'],
			'model_id' => $basketItem['model_id']
		);

		// call the delete
		if ($this->BasketManager->deleteItem($itemData)) {
			$this->Flash->success(
				Configure::read('EvBasket.flash.remove.success'),
				array(
					'key' => 'basket-flash'
				)
			);
		} else {
			$this->Flash->fail(
				Configure::read('EvBasket.flash.remove.fail'),
				array(
					'key' => 'basket-flash'
				)
			);
		}

		// process redurect
		if (Configure::read('EvBasket.redirects.delete') === 'referer') {
			$redirect = $this->referer();
		} else {
			$redirect = Configure::read('EvBasket.redirects.delete');
		}

		$this->redirect(
			$redirect
		);
	}

	/**
	 * loop and update the basket items
	 *
	 */
	public function update() {
		// process redirect
		if (Configure::read('EvBasket.redirects.update') === 'referer') {
			$redirect = $this->referer();
		} else {
			$redirect = Configure::read('EvBasket.redirects.update');
		}

		// check it's a post request and that we have data
		if (! $this->request->is('post') || empty($this->request->data)) {
			$this->redirect($this->referer());
		}

		//format the array and pass to update
		$toUpdate = Hash::combine(
			$this->request->data,
			'{n}.BasketItem.id',
			'{n}.BasketItem'
		);

		if ($this->BasketManager->updateItem($toUpdate)) {
			$this->Flash->success(
				Configure::read('EvBasket.flash.update.success'),
				array(
					'key' => 'basket-flash'
				)
			);
		} else {
			$this->Flash->fail(
				Configure::read('EvBasket.flash.update.fail'),
				array(
					'key' => 'basket-flash'
				)
			);
		}

		// redirect
		$this->redirect(
			$redirect
		);
	}

	/**
	 * add a new item to the basket
	 */
	public function add() {

		// process redirect
		if (Configure::read('EvBasket.redirects.add') === 'referer') {
			$redirect = $this->referer();
		} else {
			$redirect = Configure::read('EvBasket.redirects.add');
		}

		// check it's a post request and that we have data
		if (! $this->request->is('post') || empty($this->request->data)) {
			$this->redirect($this->referer());
		}

		// check we have all the fields needed to add an item to the basket
		if (! $this->BasketManager->checkAddItem($this->request->data)) {
			$this->redirect($this->referer());
		}

		// setup the data
		$item = array(
			'model' => $this->request->data['BasketItem']['model'],
			'model_id' => $this->request->data['BasketItem']['model_id']
		);
		$quantity = $this->request->data['BasketItem']['quantity'];

		$Model = EvClassRegistry::init($item['model']);
		$unitPrice = $Model->getUnitPrice($item['model_id']);

		// if there's a method to get the taxRate, do so
		$taxRate = 0;
		if (method_exists($Model, 'getTaxRate')) {
			$taxRate = $Model->getTaxRate($item['model_id']);
		}

		if ($unitPrice !== false) {
			// add to the basket
			if ($this->BasketManager->addItem($item, $unitPrice, $quantity, $taxRate)) {
				$this->Flash->success(
					Configure::read('EvBasket.flash.add.success'),
					array(
						'key' => 'basket-flash'
					)
				);
			} else {
				$this->Flash->fail(
					Configure::read('EvBasket.flash.add.fail'),
					array(
						'key' => 'basket-flash'
					)
				);
			}

		} else {
			$this->Flash->fail(
				Configure::read('EvBasket.flash.add.fail'),
				array(
					'key' => 'basket-flash'
				)
			);
		}

		// redirect
		$this->redirect(
			$redirect
		);
	}
}
