<?php
/**
 * BasketItem Fixture
 */
class BasketItemFixture extends CakeTestFixture {

	public $table = 'ev_basket_basket_items';

/**
 * Fields
 *
 * @var array
 */
	public $fields = array(
		'id' => array('type' => 'integer', 'null' => false, 'default' => null, 'length' => 10, 'unsigned' => false, 'key' => 'primary'),
		'basket_id' => array('type' => 'integer', 'null' => false, 'default' => null, 'length' => 10, 'unsigned' => false, 'key' => 'index'),
		'model' => array('type' => 'string', 'null' => true, 'default' => null, 'length' => 250, 'collate' => 'utf8mb4_general_ci', 'charset' => 'utf8mb4'),
		'model_id' => array('type' => 'integer', 'null' => true, 'default' => null, 'length' => 10, 'unsigned' => false),
		'unit_price' => array('type' => 'decimal', 'null' => true, 'default' => null, 'length' => '12,6', 'unsigned' => false),
		'tax_rate' => array('type' => 'decimal', 'null' => true, 'default' => null, 'length' => '6,2', 'unsigned' => false),
		'quantity' => array('type' => 'integer', 'null' => true, 'default' => null, 'length' => 10, 'unsigned' => false),
		'row_total' => array('type' => 'decimal', 'null' => true, 'default' => null, 'length' => '12,6', 'unsigned' => false),
		'created' => array('type' => 'datetime', 'null' => true, 'default' => null),
		'modified' => array('type' => 'datetime', 'null' => true, 'default' => null),
		'indexes' => array(
			'PRIMARY' => array('column' => 'id', 'unique' => 1),
			'fk_basket_items_basket1_idx' => array('column' => 'basket_id', 'unique' => 0)
		),
		'tableParameters' => array('charset' => 'utf8mb4', 'collate' => 'utf8mb4_general_ci', 'engine' => 'InnoDB')
	);

/**
 * Records
 *
 * @var array
 */
	public $records = array(
		array(
			'id' => 1,
			'basket_id' => 1,
			'model' => 'EvBasket.TestModel',
			'model_id' => 1,
			'unit_price' => '83.325',
			'row_total' => '99.99',
			'tax_rate' => 20,
			'quantity' => 1,
			'created' => '2015-08-17 08:59:29',
			'modified' => '2015-08-17 08:59:29'
		),
		array(
			'id' => 2,
			'basket_id' => 1,
			'model' => 'EvBasket.TestModel',
			'model_id' => 2,
			'unit_price' => '5.50',
			'quantity' => 1,
			'row_total' => '5.50',
			'tax_rate' => 0,
			'created' => '2015-08-17 08:59:29',
			'modified' => '2015-08-17 08:59:29'
		)
	);

}
