<?php
App::uses('EvBasketAppModel', 'EvBasket.Model');

class BasketItemData extends EvBasketAppModel {

	public $belongsTo = [
		'BasketItem' => [
			'className' => 'BasketItem',
			'foreignKey' => 'basket_item_id',
			'conditions' => '',
			'fields' => '',
			'order' => ''
		]
	];

/**
 * Set a data row for the basket item (updates or creates one based on the basket item id and name).
 *
 * @param int    $basketItemId Id of the basket that the record belongs to.
 * @param string $name         Name of the data row.
 * @param string $data         Value of the data row.
 * @return bool True is saved successfully, false otherwise.
 */
	public function setItemData($basketItemId, $name, $data) {
		$record = $this->find(
			'first',
			[
				'conditions' => [
					'basket_item_id' => $basketItemId,
					'name' => $name
				]
			]
		);

		if (!empty($record)) {
			$this->set('id', $record['BasketItemData']['id']);
		} else {
			$this->clear();
		}

		$this->set([
			'basket_item_id' => $basketItemId,
			'name' => $name,
			'item_data' => $data
		]);

		return $this->save();
	}

}
