<?php
App::uses('EvBasketAppModel', 'EvBasket.Model');
/**
 * BasketData Model
 *
 * @property Basket $Basket
 */
class BasketData extends EvBasketAppModel {

/**
 * Display field
 *
 * @var string
 */
	public $displayField = 'name';

/**
 * Validation rules
 *
 * @var array
 */
	public $validate = array(
		'basket_id' => array(
			'notBlank' => array(
				'rule' => array('notBlank'),
				//'message' => 'Your custom message here',
				//'allowEmpty' => false,
				//'required' => false,
				//'last' => false, // Stop validation after this rule
				//'on' => 'create', // Limit validation to 'create' or 'update' operations
			),
		),
		'name' => array(
			'notBlank' => array(
				'rule' => array('notBlank'),
				//'message' => 'Your custom message here',
				//'allowEmpty' => false,
				//'required' => false,
				//'last' => false, // Stop validation after this rule
				//'on' => 'create', // Limit validation to 'create' or 'update' operations
			),
		),
	);

	// The Associations below have been created with all possible keys, those that are not needed can be removed

/**
 * belongsTo associations
 *
 * @var array
 */
	public $belongsTo = array(
		'Basket' => array(
			'className' => 'Basket',
			'foreignKey' => 'basket_id',
			'conditions' => '',
			'fields' => '',
			'order' => ''
		)
	);

/**
 * set a data row for the basket (updates or creates one based on the basket id and name)
 *
 * @param int      $basketId   id of the basket that the record belongs to
 * @param string   $name       name of the data row
 * @param string   $data       value of the data row
 */
	public function setData($basketId, $name, $data, $isVisible = false) {
		$record = $this->find('first', array(
			'conditions' => array(
				'basket_id' => $basketId,
				'name' => $name
			)
		));

		if (!empty($record)) {
			$this->set('id', $record['BasketData']['id']);
		} else {
			$this->clear();
		}

		$this->set(array(
			'basket_id' => $basketId,
			'name' => $name,
			'is_visible' => $isVisible
		));

		$this->set('data', $data);

		return (bool)$this->save();
	}

/**
 * delete a single piece of data from the basket
 *
 * @param 	array 		$basketItem 	The existing BasketItem Row
 * @return 	bool
 */
	public function deleteData($basketData) {
		$this->clear();

		return $this->deleteAll(['BasketData.id' => Hash::extract($basketData, '{n}.id')]);
	}
}
