<?php

App::uses('CakeEventListener', 'Event');

App::uses('CakeLog', 'Log');

class EvBasketClearUserCookieListener implements CakeEventListener {

	public function implementedEvents() {
		return array(
			'Auth.afterLogout' => 'clearBasketCookie'
		);
	}

/**
 * Clears the current basket cookie associated with the users
 *
 * @param  CakeEvent $Event [description]
 * @return bool
 */
	public function clearBasketCookie(CakeEvent $Event) {
		App::uses('BasketCookie', 'EvBasket.Controller/Component');
		$this->BasketCookie = new BasketCookieComponent(new ComponentCollection());
		$this->BasketCookie->write('basketHash', false);

		App::uses('Basket', 'EvBasket.Controller/Component');
		$this->BasketManager = new BasketComponent(new ComponentCollection());
		$this->BasketManager->resetBasket();

		return true;
	}
}
