<?php

App::uses('EvBasketAppController', 'EvBasket.Controller');

class BasketDropoutsController extends EvBasketAppController {

	public function beforeFilter() {
		parent::beforeFilter();

		$this->Auth->allow(['index', 'view']);
	}

/**
 * User will be sent here from an email link because they ditched their basket before we got their money.
 * The aim here is to rebuild the basket, log the user in and send them off to the checkout payment screen.
 * @param  $token
 * @return
 */
	public function view($token) {
		$this->loadModel('EvBasket.Basket');
		$this->loadModel('EvCoreUser');

		// get the dropout record to retrieve basket hash
		$data = $this->BasketDropout->findByToken($token);

		if (empty($data)) {
			$this->Flash->fail('The basket has expired, please create a new one');

			return $this->redirect('/');
		}

		// write hash to cookie - this is all we need to rebuild the basket
		$this->BasketCookie->write(
			'basketHash',
			$data['BasketDropout']['basket_hash']
		);

		// retrieve user data
		$user = $this->EvCoreUser->getUserForLogin($data['BasketDropout']['user_id']);

		// log the user in
		$this->Auth->login($user);

		// this allows us to populate form data when user lands on the checkout page
		$this->_processRequestData($user);
		$this->_redirect();
	}

/**
 * Handles the redirect after the basket has been rebuilt
 * @return
 */
	protected function _redirect() {
		$url = Configure::read('EvBasket.basketDropout.redirect');

		// keep query string
		if (is_array($url) && empty($url['?']) && !empty($this->request->query)) {
			$url['?'] = $this->request->query;
		}

		return $this->redirect(
			$url
		);
	}

/**
 * Handles storing the basket dropout data such as user/address details in a session
 * @param  Array $user
 * @param  Array $address
 * @return
 */
	protected function _processRequestData($user) {
		$Address = EvClassRegistry::init('EvAddressBook.Address');
		$address = $Address->getAddresses('EvCore.User', $user['User']['id']);

		// create a session variable so we can pre populate the checkout details
		$dropoutBasketData = array_merge($address[0], $user);
		$this->Session->write('dropoutBasketData', $dropoutBasketData);
	}

}
