<?php

$config = array(
	'EvBasket' => array(
		/**
		 * the content page id to use as an intro for the basket
		 */
		'pageId' => null,

		/**
		 * BelongsTo Relationships for the BasketItem to dynamically load
		 * So we can nicely contain the data on the basket page
		*/
		'BasketItemBelongsTo' => array(
		),

		/**
		 * Sub Contains for the Basket Item - allows you to customise
		 * the data that is retrieve for a line item.
		 * If empty will default to all the BelongsTo Relationships
		*/
		'BasketItemContains' => array(
			'BasketItemData'
		),

		/**
		 * Define how each model can access the data it needs to display on the basket page
		*/
		'BasketItemNamePath' => array(
		),

		/**
		 * name label to use for the grand total row
		 */
		'labels' => array(
			'subtotal' => 'Subtotal',
			'tax' => 'Tax',
			'delivery' => 'Delivery',
			'grandtotal' => 'Grand Total',
			'discount' => 'Discount',
			'voucher' => 'Voucher'
		),

		/**
		 * Names of the labels that should be treated as discounts.
		 * If a label is treated as a discount then it will be used when rebuilding the totals to reduce the tax by
		 * a portion of the discount amount. Allows custom discount totals to work with the current basket.
		 */
		'discountLabels' => array(
			'discount',
			'voucher',
		),

		/**
		 * add a default value of shipping to basket as a placeholder
		 * set to false to disable this functionality
		 */
		'deliveryPlaceholder' => false,

		/**
		 * delivery tax rate - as a percentage - set to false to disable taxing shipping
		 */
		'deliveryTax' => false,

		/**
		 * redirects for add / update / delete
		 */
		'redirects' => array(
			'add' => array( // url array or 'referer' to use $this->referer()
				'action' => 'index'
			),
			'add_multiple' => array( // url array or 'referer' to use $this->referer()
				'action' => 'index'
			),
			'update' => array( // url array or 'referer' to use $this->referer()
				'action' => 'index'
			),
			'delete' => array( // url array or 'referer' to use $this->referer()
				'action' => 'index'
			)
		),

		/**
		 * flash message text for each action
		 * respective array passed straight into the flash method
		 */
		'flash' => array(
			'add' => array(
				'success' => array(
					'title' => 'Items added',
					'description' => 'Item has been added to the basket'
				),
				'fail' => array(
					'title' => 'Failed',
					'description' => 'There was a problem adding the items to the basket'
				)
			),
			'add_multiple' => array(
				'success' => array(
					'title' => 'Items added',
					'description' => 'Items have been added to the basket'
				),
				'warning' => array(
					'title' => 'Some items were not added',
					'description' => 'Some items were not able to be added to the basket',
				),
				'fail' => array(
					'title' => 'Failed',
					'description' => 'There was a problem adding the items to the basket'
				)
			),
			'update' => array(
				'success' => array(
					'title' => 'Items Updated',
					'description' => 'Items have been updated'
				),
				'fail' => array(
					'title' => 'Update Failed',
					'description' => 'There was a problem updating the items in the basket'
				)
			),
			'remove' => array(
				'success' => array(
					'title' => 'Item Removed',
					'description' => 'Item has been removed from basket'
				),
				'fail' => array(
					'title' => 'Remove Failed',
					'description' => 'There was a problem removing the item from the basket'
				)
			)
		),

		/**
		 * routes for use within the templates incase any overriding takes place
		 */
		'route' => array(
			'Basket' => array(
				'controller' => 'ev_basket.basket',
				'action' => 'index',
				'plugin' => 'EvBasket'
			)
		),

		/**
		 * Toggle on / off plugin based listeners - prevent problems that can arise when
		 * extening the plugin and adding app based events
		 */
		'enableListeners' => true,

		/**
		 * Toggle on / off displaying tax separately in the basket when displaying totals.
		 */
		'siteIncludingTax' => false,

		/**
		 * Toggle whether baskets should be stored against the user account or not
		 * defaults of false
		 */
		'associateBasketWithUser' => false,

		/*
		 * Basket Dropout Configuration
		 */
		'basketDropout' => array(
			'email_subject' => 'Continue Shopping',
			'email_body' => 'You recently added some items to your basket but did not complete the payment. Is there anything we can help you with?',
			'email_link_text' => 'Continue Shopping',
			// Set the redirect location after the users basket has been rebuilt. Can be an array format URL or a regular string
			'redirect' => array(
				'plugin' => 'ev_checkout',
				'controller' => 'checkout',
				'action' => 'stage',
				'customer-details'
			),
			// The amount of time that a basket has to be inactive for it to be classed as abandoned,
			// In the format of SQL Intervals e.g. "30 minute" "2 hour" "1 day" etc. (https://dev.mysql.com/doc/refman/5.5/en/date-and-time-functions.html#function_date-sub)
			'minInactivityTime' => "2 hour",
			// The amount of time ago that the users email must not appear on a completed order to become eligible for a dropout email.
			'minLastOrderedTime' => "1 week"
		),

		// To enabled editing orders using the basket, set this to EvCheckout.OrderEditing or a custom value.
		// The component must have the same public interface as EvCheckout.OrderEditingComponent
		'editOrderComponent' => false,
	)
);
