<?php

App::uses('AppHelper', 'View/Helper');
App::uses('BasketLib', 'EvBasket.Lib');

class BasketHelper extends AppHelper {

	/**
	 * given the basket item array row
	 * return the text to show on the basket
	 *
	 * @param 	array 	$BasketItem 	The basket item row from the DB
	 * @return 	string
	 */
	public function getItemName($BasketItem) {
		return BasketLib::getItemName($BasketItem);
	}

	/**
	 * helper to just generate the bakset item id and quantity field
	 * keep the template neater
	 *
	 * @param 	array 	$BasketItem 	The basket item row from the DB
	 * @param 	array 	$options 		Form Options array for the quantity - to override class and such
	 * @return 	string
	 */
	public function quantityField($BasketItem, $options = array()) {
		echo $this->_View->Form->addField(
			$BasketItem['id'] . '.BasketItem.id',
			array(
				'type' => 'hidden',
				'value' => $BasketItem['id']
			)
		);

		echo $this->_View->Form->addField(
			$BasketItem['id'] . '.BasketItem.model',
			array(
				'type' => 'hidden',
				'value' => $BasketItem['model']
			)
		);

		echo $this->_View->Form->addField(
			$BasketItem['id'] . '.BasketItem.model_id',
			array(
				'type' => 'hidden',
				'value' => $BasketItem['model_id']
			)
		);

		$options = array_merge(
			array(
				'type' => 'integer',
				'value' => $BasketItem['quantity'],
				'label' => false
			),
			$options
		);

		echo $this->_View->Form->addField(
			$BasketItem['id'] . '.BasketItem.quantity',
			$options
		);
	}

	/**
	 * helper for a delete item link
	 * keeps the template neater
	 *
	 * @param 	array 	$BasketItem 	The basket item row from the DB
	 * @param 	string  $linkText 		The text for the link
	 * @param 	array 	$linkOptions 	Options to be passed to Html->link()
	 * @return 	string
	 */
	public function deleteLink($BasketItem, $linkText, $linkOptions = array()) {
		$route = $this->_View->Route->getItemRoute('EvBasket', 'Basket');
		$route['action'] = 'remove';
		$route[] = $BasketItem['id'];

		$options = array_merge(
			array(
				'confirm' => 'Are you sure?'
			),
			$linkOptions
		);

		echo $this->_View->Html->link(
			$linkText,
			$route,
			$options
		);
	}

	/**
	 * helper to return the basket form update url
	 *
	 * @return string
	 */
	public function getFormUrl($type) {
		$route = $this->_View->Route->getItemRoute('EvBasket', 'Basket');
		$route['action'] = $type;

		return $route;
	}
}
