<?php
App::uses('BasketTotal', 'EvBasket.Model');

/**
 * BasketTotal Test Case
 */
class BasketTotalTest extends CakeTestCase {

/**
 * Fixtures
 *
 * @var array
 */
	public $fixtures = array(
		'plugin.ev_basket.basket_total',
		'plugin.ev_basket.basket',
		'plugin.ev_basket.basket_item'
	);

/**
 * setUp method
 *
 * @return void
 */
	public function setUp() {
		parent::setUp();
		$this->BasketTotal = ClassRegistry::init('EvBasket.BasketTotal');
	}

/**
 * tearDown method
 *
 * @return void
 */
	public function tearDown() {
		unset($this->BasketTotal);

		parent::tearDown();
	}

	public function testfindGrandTotalRowCanFindAndReturnCorrectKey() {
		$totals = $this->BasketTotal->find(
			'all',
			array(
				'conditions' => array(
					'BasketTotal.basket_id' => 1
				),
				'order' => 'BasketTotal.sequence ASC'
			)
		);

		$this->assertEquals(
			1,
			$this->BasketTotal->findGrandTotalRow($totals)
		);
	}

	public function testfindGrandTotalRowReturnsFalseWhenNotFound() {
		$totals = $this->BasketTotal->find(
			'all',
			array(
				'conditions' => array(
					'BasketTotal.basket_id' => 1,
					'BasketTotal.is_grand_total' => 0
				),
				'order' => 'BasketTotal.sequence ASC'
			)
		);

		$this->assertFalse(
			$this->BasketTotal->findGrandTotalRow($totals)
		);
	}
}
