<?php

App::uses('CakeTime', 'Utility');

/**
 * Static lib to share code between helper and components
 */
class BasketLib {

	/**
	 * given the basket item array row
	 * return the text to show on the basket
	 *
	 * @param 	array 	$BasketItem 	The basket item row from the DB
	 * @return 	string
	 */
	public static function getItemName($BasketItem) {
		// Try to find the model name
		$modelName = Hash::get($BasketItem, 'model');
		if (empty($modelName)) {
			return 'Unknown';
		}

		// get the config so we know where to find the data for this row
		$config = Configure::read('EvBasket.BasketItemNamePath');
		if (empty($config[$modelName])) {
			return 'Unknown';
		}
		// reposition array to make it easier to work
		$config = $config[$modelName];

		$separator = ' ';
		if (! empty($config['separator'])) {
			$separator = $config['separator'];
			unset($config['separator']);
		}

		if (! is_array($config)) {
			$config = array($config);
		}

		$item = array();
		foreach ($config as $path) {
			$value = Hash::get($BasketItem, $path);

			if (! empty($value) && stripos(implode('', $item), $value) === false) {
				$item[] = $value;
			}
		}

		if (empty($item)) {
			return 'Unknown';
		}

		return implode($separator, $item);
	}

	/**
	 * clear old baskets by checking grand total row for each one
	 *
	 * @param 	int 	$olderThan 			Delete any baskets older than time() - $olderThan
	 * @return 	int 	$numDeletedItems 	Number of items deleted
	 */
	public static function cleanBaskets($olderThan = WEEK) {
		$BasketTotal = EvClassRegistry::init('EvBasket.BasketTotal');

		$date = CakeTime::toServer(
			(time() - $olderThan),
			Configure::read('Config.timezone')
		);

		$totals = $BasketTotal->find(
			'all',
			array(
				'conditions' => array(
					'BasketTotal.modified <=' => $date
				),
				'callbacks' => false
			)
		);
		$basketIds = array_unique(Hash::extract($totals, '{n}.BasketTotal.basket_id'));
		$deleted = 0;
		if (! empty($basketIds)) {
			$Basket = EvClassRegistry::init('EvBasket.Basket');

			foreach ($basketIds as $id) {
				if ($Basket->delete($id)) {
					$deleted++;
				}
			}
		}

		return $deleted;
	}

	/**
	 * delete a basket
	 *
	 * @param 	int 	$basketId 	The basket to remove
	 * @return 	bool
	 */
	public static function deleteBasket($basketId) {
		$Basket = EvClassRegistry::init('EvBasket.Basket');

		return $Basket->delete($basketId);
	}

}
