<?php

$config = array(
	'EvBasket' => array(
		/**
		 * the content oage id to use as an intro for the basket
		 */
		'pageId' => null,

		/**
		 * BelongsTo Relationships for the BasketItem to dynamically load
		 * So we can nicely contain the data on the basket page
		*/
		'BasketItemBelongsTo' => array(
		),

		/**
		 * Sub Contains for the Basket Item - allows you to customise
		 * the data that is retrieve for a line item.
		 * If empty will default to all the BelongsTo Relationships
		*/
		'BasketItemContains' => array(
		),

		/**
		 * Define how each model can access the data it needs to display on the basket page
		*/
		'BasketItemNamePath' => array(
		),

		/**
		 * name label to use for the grand total row
		 */
		'labels' => array(
			'subtotal' => 'Subtotal',
			'tax' => 'Tax',
			'delivery' => 'Delivery',
			'grandtotal' => 'Grand Total',
			'discount' => 'Discount'
		),

		/**
		 * add a default value of shipping to basket as a placeholder
		 * set to false to disable this functionality
		 */
		'deliveryPlaceholder' => false,

		/**
		 * delivery tax rate - as a percentage - set to false to disable taxing shipping
		 */
		'deliveryTax' => false,

		/**
		 * redirects for add / update / delete
		 */
		'redirects' => array(
			'add' => array( // url array or 'referer' to use $this->referer()
				'action' => 'index'
			),
			'update' => array( // url array or 'referer' to use $this->referer()
				'action' => 'index'
			),
			'delete' => array( // url array or 'referer' to use $this->referer()
				'action' => 'index'
			)
		),

		/**
		 * flash message text for each action
		 * respective array passed straight into the flash method
		 */
		'flash' => array(
			'add' => array(
				'success' => array(
					'title' => 'Items added',
					'description' => 'Item has been added to the basket'
				),
				'fail' => array(
					'title' => 'Failed',
					'description' => 'There was a problem adding the items to the basket'
				)
			),
			'update' => array(
				'success' => array(
					'title' => 'Items Updated',
					'description' => 'Items have been updated'
				),
				'fail' => array(
					'title' => 'Update Failed',
					'description' => 'There was a problem updating the items in the basket'
				)
			),
			'remove' => array(
				'success' => array(
					'title' => 'Item Removed',
					'description' => 'Item has been removed from basket'
				),
				'fail' => array(
					'title' => 'Remove Failed',
					'description' => 'There was a problem removing the item from the basket'
				)
			)
		),

		/**
		 * routes for use within the templates incase any overriding takes place
		 */
		'route' => array(
			'Basket' => array(
				'controller' => 'ev_basket.basket',
				'action' => 'index',
				'plugin' => 'EvBasket'
			)
		)
	)
);
