<?php

App::uses('AppHelper', 'View/Helper');

App::uses('AuditLogPresenter', 'EvAuditLog.Lib');

class EvAuditLogHelper extends AppHelper {

/**
 * Inject the audit log tab into the admin form.
 *
 * @return void.
 */
	public function injectAdminForm() {
		echo $this->element(
			'form_tab',
			[
				'title' => 'Audit Log',
				'tabContent' => $this->element('EvAuditLog.Audit/audit-tab'),
			]
		);
	}

/**
 * If this property should appear on the audit log
 *
 * @param array $audit The array of audit data
 * @param array $auditDelta The array of audit delta data
 * @return bool
 */
	public function shouldPresentProperty($audit, $auditDelta) {
		$presenter = AuditLogPresenter::init($audit['model']);
		return (!empty($auditDelta['old_value']) || !empty($auditDelta['new_value'])) && $presenter->shouldPresentProperty($audit, $auditDelta);
	}

/**
 * Helper method to call the audit log presenter to present the property name.
 *
 * @param array $audit      The array of audit data.
 * @param array $auditDelta The array of audit delta data.
 * @return string The presentable value.
 */
	public function presentPropertyName($audit, $auditDelta) {
		$presenter = AuditLogPresenter::init($audit['model']);
		return $presenter->presentPropertyName($audit, $auditDelta);
	}

/**
 * Helper method to call the audit log presenter to present the old value.
 *
 * @param array $audit      The array of audit data.
 * @param array $auditDelta The array of audit delta data.
 * @return string The presentable value.
 */
	public function presentOldValue($audit, $auditDelta) {
		$presenter = AuditLogPresenter::init($audit['model']);
		return $presenter->presentOldValue($audit, $auditDelta);
	}

/**
 * Helper method to call the audit log presenter to present the new value.
 *
 * @param array $audit      The array of audit data.
 * @param array $auditDelta The array of audit delta data.
 * @return string The presentable value.
 */
	public function presentNewValue($audit, $auditDelta) {
		$presenter = AuditLogPresenter::init($audit['model']);
		return $presenter->presentNewValue($audit, $auditDelta);
	}

/**
 * Helper method to decide if an audit item should be shown
 *
 * @param array $audit The audit data
 * @param array $auditDeltas An array of deltas
 * @return string The item name
 */
	public function shouldPresentItem($audit, $auditDeltas) {
		$presenter = AuditLogPresenter::init($audit['model']);
		$result = $presenter->shouldPresentItem($audit);

		if ($result) {
			// Check for at least one visible property
			foreach ($auditDeltas as $delta) {
				if ($this->shouldPresentProperty($audit, $delta)) {
					return true;
				}
			}
		}

		return false;
	}

/**
 * Helper method to show the item name that is being affected in the audit
 *
 * @param array $audit The audit data
 * @return string The item name
 */
	public function presentItemName($audit) {
		$presenter = AuditLogPresenter::init($audit['model']);
		return $presenter->presentItemName($audit);
	}
}
