<?php if (empty($audits)): ?>
	No audit logs have been found.
<?php else: ?>
	<table class="audit-table results">
		<tbody>
			<tr>
				<th>User</th>
				<th>Audit</th>
			</tr>

			<?php
				$auditIndex = 0;
			?>

			<?php foreach ($audits as $audit): ?>
				<?php if ($this->EvAuditLog->shouldPresentItem($audit['Audit'], $audit['AuditDelta'])): ?>
					<tr class="<?= $auditIndex % 2 == 0 ? 'odd' : 'even' ?>">
						<td class="audit-table__created" valign="top" width="25%">
							<?= $audit['Audit']['description'] ?><br />
							<?php echo $this->EvAuditLog->presentItemName($audit['Audit']) ?><br />
							@ <?= $this->Time->format($audit['Audit']['created'], '%d-%m-%Y %l:%M%P') ?>
						</td>

						<td class="audit-table__log" width="75%">
							<?php if ($audit['Audit']['event'] === 'MESSAGE'): ?>
								<div class="audit-table__log__message">
									<?php
										$messageDelta = reset($audit['AuditDelta']);

										echo $messageDelta['new_value'];
									?>
								</div>
							<?php else: ?>
								<?php foreach ($audit['AuditDelta'] as $auditDelta): ?>
									<?php if ($this->EvAuditLog->shouldPresentProperty($audit['Audit'], $auditDelta)): ?>
										<table class="audit-table__log__table" cellspacing="0" cellpadding="5" border="0">
											<tr>
												<th colspan="2">
													<?php
														echo $this->EvAuditLog->presentPropertyName(
															$audit['Audit'],
															$auditDelta
														);
													?>
												</th>
											</tr>
											<tr>
												<td valign="top" width="50%">
													<strong>Before</strong><br />
													<?php
														echo $this->EvAuditLog->presentOldValue(
															$audit['Audit'],
															$auditDelta
														);
													?>
												</td>
												<td valign="top" width="50%">
													<strong>After</strong><br />
													<?php
														echo $this->EvAuditLog->presentNewValue(
															$audit['Audit'],
															$auditDelta
														);
													?>
												</td>
											</tr>
										</table>
									<?php endif; ?>
								<?php endforeach; ?>
							<?php endif; ?>
						</td>
					</tr>
					<?php $auditIndex++ ?>
				<?php endif; ?>
			<?php endforeach; ?>
		</tbody>
	</table>
<?php endif; ?>
<?php
	echo $this->Html->css('EvAuditLog.admin_audit_tab.css', ['inline' => false]);
