# EvAuditLog

## Setup

- Run the migrations to get the audit tables (`audits` and `audit_deltas`).
- Add the `EvAuditLogAuditableBehavior` to the models you wish to be audited.
- Add the `EvAuditLogComponent` and `EvAuditLogHelper` to the inject settings of the controller you wish to display the audit log on. Add the following to `admin_edit`:

    ```
    $this->toInject('components', 'EvAuditLog.EvAuditLog');
    $this->toInject('helpers', 'EvAuditLog.EvAuditLog');
    ```
    
## AuditLogBehavior settings

This plugin uses the `AuditLog` plugin to deal with detecting changes in models and creating the audits. It has 2 behavior settings that can be used in the `EvAuditLogAuditableBehavior` to modify what is detected when saving a model.
 - `ignore` An array of field names that will be ignored when detecting changes in model data. Defaults to: "created", "updated" and "modified".
 - `habtm` An array of habtm models to detect changes in when saving model data. By default the `AuditableBehavior` doesn't detect changes in habtm relationships so use this setting if you want to change that.

## Containing associated logs

An audit log can contain audit logs from associated models. To do this, set up a contain array of the model audits you want to include in the behavior settings of the model you are displaying audits of. The array should have the key `containLog`. For example if you wished to contain a full log of an EvCheckout.Order model you may set up the `containLog` like so:

```
public $actsAs = [
	'EvAuditLog.EvAuditLogAuditable' => [
		'containLog' => [
			'OrderItem' => [
				'OrderItemData',
			],
			'OrderData',
			'OrderNote',
			'OrderTotal',
		]
	],
];

```

The associated audit logs will be contained as part of the original models audit log list. They are currently not distinguished in the audit log.

## Linked Models
Sometimes the same data can be used by various models. While an audit record will only be recorded against one model, they can be fetched using multiple model aliases using the same record ID so they can be combined when viewed. To do this, add a `getAuditLinkedModels()` method in your model that returns an array of model names as recorded in the `audits` table.

## Custom Model Name
By default, any model names on audit logs will be recorded using the `Plugin.Alias` syntax. This can be overridden by implementing `getAuditModelName()` in the model. This is useful if there are multiple models using the same alias.

##Custom presenters

`EvAuditLog` contains a `AuditLogPresenter` library file that is used by the audit log helper to present values in the audit log. It has methods to present boolean values and to lookup values when the field that changed was an Id field. It will attempt to present a value using a presenter in the plugin that the value was changed in. For example:

In EvCheckout, when a status of an order is changed, the `order_status_id` is audited. Without a presenter the id value will be shown as is. With a `OrderAuditLogPresenter` library class in the `EvCheckout` plugin (`Lib/AuditLog/`), the order status can be displayed as the name of the status it was actually changed to. If a plugin presenter doesn't exist or needs to be extended then the presenter will check the project first for a plugin presenter file and use that instead. To override the plugin presenter, place a file in `Lib/AuditLog/PluginModelAuditLogPresenter.php` replacing `Plugin` and `Model` with the plugin name and the model alias. Be sure to extend the original plugin presenter so the original functionality isn't lost.

## TroubleShooting

### Audit model field does not include plugin prefix
When saving an audit the current model being saved is added to the audit. The audit model should be the full className of the model and not just the alias. If the model is missing the plugin prefix then check to see if the $Model->plugin value is set, preferably in the AppModel of the plugin. It is not possible to acquire the className in the AuditLogBehavior so it is created from the plugin and the alias values. The plugin value defaults to null but should be set on all plugin models. Most plugins won't have this as it isn't necessary.
