$(document).ready(function() {
	if (typeof window.app !== 'undefined') {
		if (typeof window.app.addressFormInputPrefix !== 'undefined') {
			var addressFormInputPrefix = window.app.addressFormInputPrefix;

			var countrySelection = $('#' + addressFormInputPrefix + 'CountryId');
			var countySelection = $('#' + addressFormInputPrefix + 'County');
			var stateSelection = $('#' + addressFormInputPrefix + 'State');

			countrySelection.change(function() {
				if (checkStateCountry(countrySelection.val())) {
					updateStateOptions(stateSelection, countrySelection.val());
					displaySelection(stateSelection, [countySelection]);
				} else {
					displaySelection(countySelection, [stateSelection]);
				}
			});

			// Check if the currently selected country requries states
			if (checkStateCountry(countrySelection.val())) {
				var selectedState = stateSelection.attr('requestValue');

				updateStateOptions(stateSelection, countrySelection.val());
				displaySelection(stateSelection, [countySelection]);

				stateSelection.val(selectedState);
			}
		}
	}
});

/**
 * Check if the country id provided has states
 * @param  int  countryId The id of the country
 * @return bool           Whether the country has states or not
 */
function checkStateCountry(countryId) {
	if (
		countryId == countryIdUS() ||
		countryId == countryIdCanada()
	) {
		return true;
	}

	return false;
}

/**
 * Update a state selector so that it contains the state options of the currently selected
 * country.
 * @param  jQueryObj selector  The select input that needs updating
 * @param  int       countryId The id of the country to get states of.
 */
function updateStateOptions(selector, countryId) {
	if (countryId == countryIdUS() && $('.us-state-selection').length > 0) {
		selector.children('option').remove();
		selector.append($('.us-state-selection > .input > select > option').clone());

	} else if (countryId == countryIdCanada() && $('.canada-state-selection').length > 0) {
		selector.children('option').remove();
		selector.append($('.canada-state-selection > .input > select > option').clone());
	}
}

/**
 * Display an input and hide any others provided. Used to switch between county and state
 * dropdowns.
 * @param  jqueryObj showSelector  The input to display.
 * @param  array     hideSelectors An array of inputs to hide.
 */
function displaySelection(showSelector, hideSelectors) {
	// Show the passed selector
	var showInputDiv = showSelector.parent().parent();
	if (showInputDiv.hasClass('hidden')) {
		showInputDiv.removeClass('hidden');
	}

	showInputDiv.show();

	// Hide the passed selectors
	hideSelectors.forEach(function(selector, index) {
		var hideInputDiv = selector.parent().parent();
		hideInputDiv.hide();
	});
}

/**
 * Get the country id for the US.
 */
function countryIdUS() {
	return 226;
}

/**
 * Get the country id for Canada.
 */
function countryIdCanada() {
	return 38;
}
