# EvAddressBook

## Installation

Simply add EvAddressBook to the `install.php` file within the Config directory and run `Console/cake installer core` once you have added all the other plugins you will need.

If this has already been run, simply run `Console/cake installer plugin EvAddressBook`.

There is no installer for this plugin, only zuul... i mean migrations.

## How it works

The address book works around the AddressBookManager component. This allows you to CRUD addresses for a user.

A controller based section is bundled with the plugin, this can be used to give the customers access to modify their own addresses via a my account style section.

## Usage

To use outside of a standard shop situation simply load up the component, either by attaching it to the components array in a controller or loading on the fly via the `loadComponent()` method available within a controller.

	$this->AddressManager = $this->loadComponent('EvAddressBook.AddressManager');

As well as all the needed CRUD options there are a couple of helper methods available on the plugin to perform certain actions.

One can be used to validate whether the given address id actually belongs to the user we are trying to load it for.

Others are used mainly during the checkout process, this is `selectAddress()` which is used to store an address as a selected address during checkout and also `findAddresses()`. This is used on the checkout summary page where we wish to get the selected address IDs and try and return the actual address stored at that ID.

A View helper also exists which calls out to the `AddressBookLib`. The only method currently available is one for formatting an address array from the database into a nicer format for displaying.

### Redirects
If you want to redirect to a page other than the address index then you can add a redirect route to the config. In your overridden config file add:

	'redirects' => array(
		'add' => array(
			'plugin' => false,
			'controller' => 'ev_core_users',
			'action' => 'account'
		),
		'edit' => array(
			'plugin' => false,
			'controller' => 'ev_core_users',
			'action' => 'account'
		),
		'delete' => array(
			'plugin' => false,
			'controller' => 'ev_core_users',
			'action' => 'account'
		)
	),

Currently redirects are checked when adding, editting and deleting an address.

### Generic Address Form
A generic form has been added as an element, `EvAddressBook.address-form` that can be used in multiple areas of the site. Designed to be used during the checkout process for delivery and billing addresses. By default it only displays information needed for UK addresses but can display the option to select a state if the config setting is enabled, `internationalAddresses`. Currently only the US and Canadian states are available. The address model can be used to validate both UK and international addresses without having to change the validation. The general address form does require the `AddressFormHelper`.

Each field can be customised by passing the attributes you want to customise in the `inputAttributes` of the element. Pass them through in the form:

	'inputAttributes' => [
		'post_code' => [
			'div' => 'field--horizontal--small',
		],
		'FIELD_NAME' => [
			'ATTRIBUTE_NAME' => 'ATTRIBUTE_VALUE',
		]
	]

### Postcode Validation
The postcode is validated as part of the address validation. By default it always validates but can be disabled on development sites if required. Some payment services require specific address details so the validation will need to be disabled. Currently only validates UK, US and Canadian postcodes.
