<?php

App::uses('AppHelper', 'View/Helper');

class AddressFormHelper extends AppHelper {

	/**
	 * Used to merge default and custom field attributes
	 *
	 * @param 	string 	$field 	  The name of the field to merge attributes for.
	 * @param 	array 	$defaults The default attributes for this field
	 * @param 	array 	$custom   The fields to customise and their custom attributes
	 * @return 	string
	 */
	public function getFieldAttributes($field = '', $defaults = [], $custom = []) {
		$attributes = $defaults;

		if (!empty($custom) && in_array($field, array_keys($custom))) {
			$customAttributes = $custom[$field];

			if (!empty($customAttributes) && is_array($customAttributes)) {
				foreach ($customAttributes as $attributeName => $attributeValue) {
					$attributes[$attributeName] = $this->_mergeAttribute($attributeName, $attributes[$attributeName], $attributeValue);
				}
			}
		}

		return $attributes;
	}

	/**
	 * Merge a single attribute. Merge according to the type of attribute that wants to be merged
	 * @param  string $attribute    The name of the attribute to merge.
	 * @param  string $defaultValue The default value of the attribute.
	 * @param  string $customValue  The custom value of the attribute to merge into the default.
	 * @return string               The merged attribute
	 */
	protected function _mergeAttribute($attribute = '', $defaultValue = null, $customValue = null) {
		if (empty($attribute) && empty($customValue)) {
			return null;
		}

		switch($attribute) {
			case 'div':
				return $defaultValue . ' ' . $customValue;
				break;
			default:
				return $defaultValue;
				break;
		}
	}
}
