<?php
	/**
	 * @param string inputPrefix     The prefix to attach to each element
	 * @param string div             Any classes to add to the div of each input
	 * @param array  inputAttributes An array for each input that contains specific attributes for that input
	 */
?>

<?php
	// Check if an international address can be used
	$canUseInternational = Configure::read('EvAddressBook.internationalAddresses');
	if ($canUseInternational):
		$this->Js->set('addressFormInputPrefix', $inputPrefix);

		echo $this->Js->writeBuffer(array('onDomReady' => false));

		$this->Html->script(
			[
				'EvAddressBook.statePicker'
			],
			[
				'inline' => false
			]
		);
	endif;

	// Sort out the inputPrefix string
	if (empty($inputPrefix)):
		$inputPrefix = '';
	else:
		$inputPrefixOriginal = $inputPrefix;
		$inputPrefix .= '.';
	endif;

	if (empty($div)) {
		$div = '';
	}

	if (empty($inputAttributes)) {
		$inputAttributes = [];
	}

	$defaultAttributes = [
		'type' => 'string',
		'label' => [
			'text' => 'Address Name',
			],
		'required' => true,
		'div' => 'required ' . $div,
		'class' => 'required'
	];
	$addressFieldAttributes = $this->AddressForm->getFieldAttributes('name', $defaultAttributes, $inputAttributes);
	echo $this->Form->addField(
		$inputPrefix . 'name',
		$addressFieldAttributes
	);

	if ($canUseInternational):
		$defaultAttributes = [
			'type' => 'integer',
			'label' => [
				'text' => 'Country',
			],
			//Set UK as default selected value
			'value' => '225',
			'div' => 'required ' . $div,
			'class' => 'required'
		];

		if (!empty($inputPrefixOriginal) && !empty($this->request->data[$inputPrefixOriginal]['country_id'])) {
			$defaultAttributes['value'] = $this->request->data[$inputPrefixOriginal]['country_id'];
		} elseif (!empty($this->request->data['country_id'])) {
			$defaultAttributes['value'] = $this->request->data['country_id'];
		}

		$addressFieldAttributes = $this->AddressForm->getFieldAttributes('country_id', $defaultAttributes, $inputAttributes);

		echo $this->Form->addField(
			$inputPrefix . 'country_id',
			$addressFieldAttributes
		);
	endif;

	$defaultAttributes = [
		'type' => 'string',
		'label' => [
			'text' => 'Address Line 1',
			],
		'required' => true,
		'div' => 'required ' . $div,
		'class' => 'required'
	];
	$addressFieldAttributes = $this->AddressForm->getFieldAttributes('address1', $defaultAttributes, $inputAttributes);
	echo $this->Form->addField(
		$inputPrefix . 'address1',
		$addressFieldAttributes
	);


	$defaultAttributes = [
		'type' => 'string',
		'label' => [
			'text' => 'Address Line 2',
		],
		'div' => '' . $div
	];
	$addressFieldAttributes = $this->AddressForm->getFieldAttributes('address2', $defaultAttributes, $inputAttributes);
	echo $this->Form->addField(
		$inputPrefix . 'address2',
		$addressFieldAttributes
	);


	$defaultAttributes = [
		'type' => 'string',
		'label' => [
			'text' => 'Town/City',
		],
		'div' => 'required ' . $div,
		'class' => 'required'
	];
	$addressFieldAttributes = $this->AddressForm->getFieldAttributes('city', $defaultAttributes, $inputAttributes);
	echo $this->Form->addField(
		$inputPrefix . 'city',
		$addressFieldAttributes
	);


	$defaultAttributes = [
		'type' => 'string',
		'label' => [
			'text' => 'County',
		],
		'div' => '' . $div
	];
	$addressFieldAttributes = $this->AddressForm->getFieldAttributes('county', $defaultAttributes, $inputAttributes);
	echo $this->Form->addField(
		$inputPrefix . 'county',
		$addressFieldAttributes
	);

	if ($canUseInternational):
		$defaultAttributes = [
			'type' => 'select',
			'label' => [
				'text' => 'State',
			],
			'div' => 'hidden required ' . $div,
			'empty' => 'Please Select',
			'requried' => 'required',
		];

		if (!empty($inputPrefixOriginal) && !empty($this->request->data[$inputPrefixOriginal]['state'])) {
			$defaultAttributes['requestValue'] = $this->request->data[$inputPrefixOriginal]['state'];
		} elseif (!empty($this->request->data['state'])) {
			$defaultAttributes['requestValue'] = $this->request->data['state'];
		}

		$addressFieldAttributes = $this->AddressForm->getFieldAttributes('state', $defaultAttributes, $inputAttributes);
		echo $this->Form->addField(
			$inputPrefix . 'state',
			$addressFieldAttributes
		);

		echo $this->element(
			'EvAddressBook.address-us-state-codes',
			[
				'form' => $inputPrefixOriginal,
				'div' => 'hidden'
			]
		);

		echo $this->element(
			'EvAddressBook.address-canada-state-codes',
			[
				'form' => $inputPrefixOriginal,
				'div' => 'hidden'
			]
		);
	endif;

	$defaultAttributes = [
		'type' => 'string',
		'label' => [
			'text' => 'Postcode',
		],
		'div' => 'required ' . $div,
		'class' => 'required'
	];
	$addressFieldAttributes = $this->AddressForm->getFieldAttributes('post_code', $defaultAttributes, $inputAttributes);
	echo $this->Form->addField(
		$inputPrefix . 'post_code',
		$addressFieldAttributes
	);
?>
