<?php

/**
 * class to share some code between components / helpers
 */
class AddressBookLib {

/**
 * Use to format and display an address
 *
 * @param 	array 	$address 	address array
 * @param 	string 	$format 	Sprintf format for each address line
 * @param 	array 	$options 	Optional configurations
 * @return 	string
 */
	public static function display($address, $format = '%s<br>', $options = []) {
		$options = Hash::merge([
			'escape' => true
		], $options);

		if ($options['escape'] === true) {
			$address['Address'] = Self::_escapeAddress(Hash::get($address, 'Address'));
		}

		$formatted = '';

		$formatted .= sprintf($format, $address['Address']['address1']);

		if (! empty($address['Address']['address2'])):
			$formatted .= sprintf($format, $address['Address']['address2']);
		endif;

		if (! empty($address['Address']['address3'])):
			$formatted .= sprintf($format, $address['Address']['address3']);
		endif;

		$formatted .= sprintf($format, $address['Address']['city']);

		if (!empty($address['Address']['county'])):
			$formatted .= sprintf($format, $address['Address']['county']);
		endif;

		if (!empty($address['Address']['state'])):
			$formatted .= sprintf($format, $address['Address']['state']);
		endif;

		$formatted .= sprintf($format, $address['Address']['post_code']);

		if (! empty($address['Country']['name'])):
			$formatted .= sprintf($format, $address['Country']['name']);
		endif;

		return $formatted;
	}

/**
 * Escapes all fields in an address record
 *
 * @param array &$address An array wit
 * @return void
 */
	protected static function _escapeAddress($address) {
		foreach ($address as &$line) {
			$line = h($line);
		}

		return $address;
	}

}
