<?php

App::uses('EvAddressBookAppController', 'EvAddressBook.Controller');

class AddressBookController extends EvAddressBookAppController {

	public function beforeFilter() {
		parent::beforeFilter();

		$this->AddressManager = $this->loadComponent('EvAddressBook.AddressManager');
		$this->helpers[] = 'EvAddressBook.AddressBook';
	}

	/**
	 * list addresses
	 */
	public function index() {
		$this->set(
			'addressBook',
			$this->AddressManager->getAddresses(
				EvClassRegistry::init('EvAddressBook.Address'),
				'EvCore.User',
				$this->Auth->user('User.id')
			)
		);

		$this->Meta->set(
			array(
				'Page' => array(
					'title' => 'Address Book'
				)
			),
			'EvCore.Page'
		);

		$this->view = 'EvAddressBook.AddressBook/index';
	}

	/**
	 * add new address
	 */
	public function add() {
		if ($this->request->is('post') && ! empty($this->request->data)) {
			$AddressModel = EvClassRegistry::init('EvAddressBook.Address');

			if (!empty($this->request->data[$AddressModel->alias]['model']) && !empty($this->request->data[$AddressModel->alias]['model_id'])) {
				$model = $this->request->data[$AddressModel->alias]['model'];
				$modelId = $this->request->data[$AddressModel->alias]['model_id'];
			} else {
				$model = 'EvCore.User';
				$modelId = $this->Auth->user('User.id');
			}
			$result = $this->AddressManager->add($AddressModel, $model, $modelId);

			// if successful select the address
			if ($result['result'] === true) {
				$this->Flash->success($result['data']['message']);

				// process redirect
				if (empty(Configure::read('EvAddressBook.redirects.add'))) {
					//default redirect route
					$redirect = $this->Routable->getItemRoute('EvAddressBook', 'Address');
				} else {
					$redirect = Configure::read('EvAddressBook.redirects.add');
				}

				$this->redirect($redirect);

			} else {
				$this->Flash->fail($result['data']['errors']);
			}
		}

		$this->set(
			'countries',
			$this->AddressManager->getCountriesForNewAddress()
		);

		$this->Meta->set(
			array(
				'Page' => array(
					'title' => 'Add Address'
				)
			),
			'EvCore.Page'
		);

		$this->view = 'EvAddressBook.AddressBook/add';
	}

	public function edit($id) {
		$Model = $this->{$this->modelClass};

		$AddressModel = EvClassRegistry::init('EvAddressBook.Address');
		$data = $this->AddressManager->getAddress($AddressModel, $id);

		if ($this->request->is('post') && ! empty($this->request->data)) {
			if (!empty($this->request->data[$AddressModel->alias]['model']) && !empty($this->request->data[$AddressModel->alias]['model_id'])) {
				$model = $this->request->data[$AddressModel->alias]['model'];
				$modelId = $this->request->data[$AddressModel->alias]['model_id'];
			} else {
				$model = 'EvCore.User';
				$modelId = $this->Auth->user('User.id');
			}
			$result = $this->AddressManager->add($AddressModel, $model, $modelId);

			// if successful select the address
			if ($result['result'] === true) {
				$this->Flash->success($result['data']['message']);

				// process redirect
				if (empty(Configure::read('EvAddressBook.redirects.edit'))) {
					//default redirect route
					$redirect = $this->Routable->getItemRoute('EvAddressBook', 'Address');
				} else {
					$redirect = Configure::read('EvAddressBook.redirects.edit');
				}

				$this->redirect($redirect);

			} else {
				$this->Flash->fail($result['data']['errors']);
			}
		}

		$CountryModel = EvClassRegistry::init('EvCountry.Country');
		$this->set(
			'countries',
			$this->AddressManager->getCountriesForNewAddress()
		);

		$this->Meta->set(
			array(
				'Page' => array(
					'title' => 'Edit Address'
				)
			),
			'EvCore.Page'
		);

		$this->request->data = $data;

		$this->view = 'EvAddressBook.AddressBook/edit';
	}

	/**
	 * delete address
	 */
	public function delete($id) {
		$AddressModel = EvClassRegistry::init('EvAddressBook.Address');

		$check = $this->AddressManager->addressBelongsToUser($AddressModel, $id, $this->Auth->user('User.id'));
		if ($check['result'] === true) {

			if ($AddressModel->delete($id)) {
				$this->Flash->success(
					'Address has been deleted'
				);
			} else {
				$this->Flash->fail(
					'There was a problem deleting the address, please try again.'
				);
			}
		} else {
			$this->Flash->fail(
				'Address deletion failed, you do not have permission to delete this address.'
			);
		}

		// process redirect
		if (empty(Configure::read('EvAddressBook.redirects.delete'))) {
			//default redirect route
			$redirect = $this->Routable->getItemRoute('EvAddressBook', 'Address');
		} else {
			$redirect = Configure::read('EvAddressBook.redirects.delete');
		}

		$this->redirect($redirect);
	}
}
