<?php
/**
 * Copyright 2010 - 2015, Cake Development Corporation (http://cakedc.com)
 *
 * Licensed under The MIT License
 * Redistributions of files must retain the above copyright notice.
 *
 * @copyright Copyright 2010 - 2015, Cake Development Corporation (http://cakedc.com)
 * @license MIT License (http://www.opensource.org/licenses/mit-license.php)
 */

use Cake\Core\Configure;

?>
<div class="card-group">
    <div class="card p-2">
        <div class="card-block">
            <?= $this->Flash->render() ?>
            <?= $this->Form->create() ?>
            <h1><?= __d('ev3_users', 'Login') ?></h1>
            <p class="text-muted"><?= __d('ev3_users', 'Sign In to your account') ?></p>
            <?=
                $this->Form->input($username,
                    [
                        'required' => true,
                        'label' => false,
                        'placeholder' => __d('ev3_users', 'Username'),
                        'templates' => [
                            'inputContainer' => '<div class="input-group mb-1"><span class="input-group-addon"><i class="fa fa-user"></i></span>{{content}}</div>'
                        ]
                    ]
                )
            ?>
            <?=
                $this->Form->input('password',
                    [
                        'required' => true,
                        'label' => false,
                        'placeholder' => __d('ev3_users', 'Password'),
                        'templates' => [
                            'inputContainer' => '<div class="input-group mb-2"><span class="input-group-addon"><i class="fa fa-unlock-alt"></i></span>{{content}}</div>'
                        ]
                    ]
                )
            ?>
            <div class="row">
                <div class="col-xs-6">
                    <?= $this->Form->button(__d('ev3_users', 'Login'), ['class' => 'btn btn-primary px-2']) ?>
                </div>
                <?php if (Configure::read('Users.Email.required')): ?>
                    <div class="col-xs-6 text-xs-right">
                        <?= $this->Html->link(__d('ev3_users', 'Forgot password?'), ['action' => 'requestResetPassword'], ['class' => 'btn btn-link px-0']) ?>
                    </div>
                <?php endif ?>
            </div>
            <?= $this->Form->end() ?>
        </div>
    </div>
</div>
