<div class="card-group">
    <div class="card p-2">
        <div class="card-block">
            <?= $this->Form->create($user) ?>
            <h1><?= __d('ev3_users', 'Password Reset') ?></h1>
            <p class="text-muted"><?= __d('ev3_users', 'Please enter a new password') ?></p>
            <?=
                $this->Form->input('password',
                    [
                        'required' => true,
                        'label' => false,
                        'placeholder' => __d('ev3_users', 'New Password'),
                        'templates' => [
                            'inputContainer' => '<div class="input-group mb-1"><span class="input-group-addon"><i class="fa fa-unlock-alt"></i></span>{{content}}</div>'
                        ]
                    ]
                )
            ?>
            <?=
                $this->Form->input('password_confirm',
                    [
                        'required' => true,
                        'label' => false,
                        'placeholder' => __d('ev3_users', 'Confirm New Password'),
                        'templates' => [
                            'inputContainer' => '<div class="input-group mb-2"><span class="input-group-addon"><i class="fa fa-unlock-alt"></i></span>{{content}}</div>'
                        ]
                    ]
                )
            ?>
            <div class="row">
                <div class="col-xs-6">
                    <?= $this->Form->button(__d('ev3_users', 'Submit'), ['class' => 'btn btn-primary px-2']) ?>
                </div>
                <div class="col-xs-6 text-xs-right">
                    <?= $this->Html->link(__d('ev3_users', 'Login'), ['action' => 'login'], ['class' => 'btn btn-link px-0']) ?>
                </div>
            </div>
            <?= $this->Form->end() ?>
        </div>
    </div>
</div>
