<?php
namespace Ev3Users\Model\Table;

use Cake\Core\Configure;
use Cake\Event\Event;
use Cake\ORM\TableRegistry;
use Cake\Validation\Validator;

/**
 * Users Model
 */
class UsersTable extends \CakeDC\Users\Model\Table\UsersTable
{
    /**
     * Default validation
     * @param Validator $validator Validator instance
     * @return Validator
     */
    public function validationDefault(Validator $validator)
    {
        $validator = parent::validationDefault($validator);
        $username = Configure::read('Auth.authenticate.Form.fields.username');
        if ($username === 'email') {
            $validator->remove('username');
        }

        return $validator;
    }

    /**
     * Extend rules for password confirm (used when setting a new password).
     * @param Validator $validator Cake validator object.
     * @return Validator
     */
    public function validationPasswordConfirm(Validator $validator)
    {
        $validator = parent::validationPasswordConfirm($validator);
        $validator->add('password', 'alphaNumeric', [
            'rule' => function ($value, $context) {
                return (bool)preg_match('/(?=.*\d)(?=.*[a-zA-Z])(?=.*[!@#$&*])/', $value);
            },
            'message' => __d('ev3_users', 'Your password must contain at least one alphabetic, one numeric character and one special character (!@#$&*)'),
            'allowEmpty' => false
        ]);
        $validator->add('password', 'case', [
            'rule' => function ($value, $context) {
                return (bool)preg_match('/(?=.*[a-z])(?=.*[A-Z])/', $value);
            },
            'message' => __d('ev3_users', 'Your password must contain at least one lowercase and one uppercase character'),
            'allowEmpty' => false
        ]);
        // @todo this rule needs updating to change the minLength depending on user group once this
        // part of the plugin has been developed. See the User::customMinPasswordLength() method in
        // the Cake 2 core.
        $validator->add('password', 'minLength', [
            'rule' => ['minLength', 15],
            'message' => __d('ev3_users', 'Your password must be a minimum of 15 characters long'),
            'allowEmpty' => false
        ]);
        $validator->add('password', 'dictionary', [
            'rule' => function ($value, $context) {
                $query = TableRegistry::get('PasswordDictionary')->find('all');
                $locate = $query->func()->locate([
                    'password' => 'literal',
                    $value
                ]);

                return !(bool)$query->where($locate)->count();
            },
            'message' => __d('ev3_users', 'Your password cannot contain any dictionary words'),
            'allowEmpty' => false
        ]);



        return $validator;
    }
}
