<?php
namespace Ev3Users\Model\Table;

use Cake\ORM\Query;
use Cake\ORM\RulesChecker;
use Cake\ORM\Table;
use Cake\Validation\Validator;

/**
 * PasswordDictionary Model
 *
 * @method \Ev3Users\Model\Entity\PasswordDictionary get($primaryKey, $options = [])
 * @method \Ev3Users\Model\Entity\PasswordDictionary newEntity($data = null, array $options = [])
 * @method \Ev3Users\Model\Entity\PasswordDictionary[] newEntities(array $data, array $options = [])
 * @method \Ev3Users\Model\Entity\PasswordDictionary|bool save(\Cake\Datasource\EntityInterface $entity, $options = [])
 * @method \Ev3Users\Model\Entity\PasswordDictionary patchEntity(\Cake\Datasource\EntityInterface $entity, array $data, array $options = [])
 * @method \Ev3Users\Model\Entity\PasswordDictionary[] patchEntities($entities, array $data, array $options = [])
 * @method \Ev3Users\Model\Entity\PasswordDictionary findOrCreate($search, callable $callback = null, $options = [])
 *
 * @mixin \Cake\ORM\Behavior\TimestampBehavior
 */
class PasswordDictionaryTable extends Table
{

    /**
     * Initialize method
     *
     * @param array $config The configuration for the Table.
     * @return void
     */
    public function initialize(array $config)
    {
        parent::initialize($config);

        $this->table('password_dictionary');
        $this->displayField('password');
        $this->primaryKey('id');

        $this->addBehavior('Timestamp');
    }

    /**
     * Default validation rules.
     *
     * @param \Cake\Validation\Validator $validator Validator instance.
     * @return \Cake\Validation\Validator
     */
    public function validationDefault(Validator $validator)
    {
        $validator
            ->integer('id')
            ->allowEmpty('id', 'create');

        $validator
            ->requirePresence('password', 'create')
            ->notEmpty('password');

        $validator
            ->boolean('is_active')
            ->requirePresence('is_active', 'create')
            ->notEmpty('is_active');

        return $validator;
    }
}
