<?php
namespace Ev3Users\Controller\Admin;

use App\Controller\Admin\AppController;
use CakeDC\Users\Controller\Traits\LoginTrait;
use CakeDC\Users\Controller\Traits\PasswordManagementTrait;
use Cake\Controller\Controller as BaseController;
use Cake\Core\Configure;

/**
 * `AuthController` for handling login/logout of admin area and password resets. The idea of this
 * controller is to keep login and password management separate to the general user admin handled by
 * the `UsersController`. The actions for this controller are defined by the `CakeDC/Users` plugin
 * traits.
 *
 * @property UsersTable $Users
 */
class AuthController extends BaseController
{
    use LoginTrait {
        login as traitLogin;
    }
    use PasswordManagementTrait;

    /**
     * Initialize and set defaults for model class
     *
     * @return void
     */
    public function initialize()
    {
        parent::initialize();
        $this->loadComponent('RequestHandler');
        $this->loadComponent('Security');
        $this->loadComponent('Flash');
        $this->loadComponent('CakeDC/Users.UsersAuth');
        $this->helpers[] = 'CakeDC/Users.User';
        // Set the controller's model to be the configured Users table for the plugin (this allows
        // us to easily override/extend this in our apps).
        $this->_setModelClass(Configure::read('Users.table'));
        $this->viewBuilder()->theme('CoreUI');
        $this->viewBuilder()->layout('auth');
    }

    /**
     * Login page (extended from the trait).
     *
     * @return mixed
     */
    public function login()
    {
        $username = Configure::read('Auth.authenticate.Form.fields.username');
        $this->set('username', $username ?: 'username');
        $this->traitLogin();
    }
}
