<?php
use Migrations\AbstractSeed;

/**
 * PasswordDictionary seed.
 */
class PasswordDictionarySeed extends AbstractSeed
{
    /**
     * Run Method.
     *
     * See the password dictionary.
     *
     * More information on writing seeds is available here:
     * http://docs.phinx.org/en/latest/seeding.html
     *
     * @return void
     */
    public function run()
    {
        $data = [];

        $filepath = dirname(__FILE__) . DS . 'password_dictionary.txt';
        if (file_exists($filepath)) {
            $dictionary = fopen($filepath, 'r');
            if ($dictionary) {
                while (($password = fgets($dictionary)) !== false) {
                    $password = trim($password);
                    if (!empty($password)) {
                        $data[] = [
                            'password' => $password,
                            'created' => gmdate('Y-m-d H:i:s'),
                            'modified' => gmdate('Y-m-d H:i:s')
                        ];
                    }
                }
            }
            fclose($dictionary);
        }
        if (!empty($data)) {
            $table = $this->table('password_dictionary');
            $table->insert($data)->save();
        }
    }
}
