<?php
namespace Ev3Settings\View\Helper;

use Cake\Core\Configure;
use Cake\View\Helper;

class SettingsHelper extends Helper
{
    /**
     * Checks if a site setting has been set.
     *
     * @param string $setting Site setting slug
     *
     * @return string
     */
    public function check($setting)
    {
        return ! empty(Configure::read('SiteSettings.' . $setting));
    }

    /**
     * Returns a site setting or the default value if the setting is not set.
     *
     * @param string $setting Site setting slug
     * @param string $defaultValue Default setting value
     *
     * @return string
     */
    public function get($setting, $defaultValue = null)
    {
        return Configure::read('SiteSettings.' . $setting) ?: $defaultValue;
    }
}
