<?= $this->fetch('before_form'); ?>

<div class="<?= $this->Cms->getCssClasses(); ?>">

    <?= $this->Form->create($settings, ['role' => 'form']); ?>

    <?php foreach ($groupedSettings as $category => $categorySettings): ?>
    <div class="row">
        <div class="col-xs-12">
            <div class="card">
                <div class="card-header">
                    <i class="fa fa-cogs" aria-hidden="true"></i> <?= h($category) ?>
                </div>
                <div class="card-block">
                    <div class="row">
                        <div class="col-xs-12">
                            <?php foreach ($categorySettings as $key => $setting): ?>
                                <?= $this->Form->input($setting->id . '.id') ?>
                                <?= $this->Form->input($setting->id . '.value', ['label' => $setting->name, 'type' => $setting->type]) ?>
                            <?php endforeach ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <?php endforeach ?>

    <?= $this->element('form/buttons', ['saveButton' => __d('ev3_settings', 'Save'), 'disableExtraButtons' => true]) ?>

    <?= $this->Form->end() ?>

</div>
