<?php
namespace Ev3Settings\Model\Table;

use Cake\ORM\Query;
use Cake\ORM\RulesChecker;
use Cake\ORM\Table;
use Cake\Validation\Validator;

/**
 * Settings Model
 *
 * @method \Ev3Settings\Model\Entity\Setting get($primaryKey, $options = [])
 * @method \Ev3Settings\Model\Entity\Setting newEntity($data = null, array $options = [])
 * @method \Ev3Settings\Model\Entity\Setting[] newEntities(array $data, array $options = [])
 * @method \Ev3Settings\Model\Entity\Setting|bool save(\Cake\Datasource\EntityInterface $entity, $options = [])
 * @method \Ev3Settings\Model\Entity\Setting patchEntity(\Cake\Datasource\EntityInterface $entity, array $data, array $options = [])
 * @method \Ev3Settings\Model\Entity\Setting[] patchEntities($entities, array $data, array $options = [])
 * @method \Ev3Settings\Model\Entity\Setting findOrCreate($search, callable $callback = null)
 *
 * @mixin \Cake\ORM\Behavior\TimestampBehavior
 */
class SettingsTable extends Table
{

    /**
     * Initialize method
     *
     * @param array $config The configuration for the Table.
     * @return void
     */
    public function initialize(array $config)
    {
        parent::initialize($config);

        $this->table('settings');
        $this->displayField('name');
        $this->primaryKey('id');

        $this->addBehavior('Timestamp');

        $this->belongsTo('SettingCategories', [
            // 'foreignKey' => 'setting_category_id',
            // 'joinType' => 'INNER',
            'className' => 'Ev3Settings.SettingCategories'
        ]);
    }

    /**
     * Default validation rules.
     *
     * @param \Cake\Validation\Validator $validator Validator instance.
     * @return \Cake\Validation\Validator
     */
    public function validationDefault(Validator $validator)
    {
        $validator
            ->integer('id')
            ->allowEmpty('id', 'create');

        $validator
            ->requirePresence('name', 'create')
            ->notEmpty('name');

        $validator
            ->requirePresence('slug', 'create')
            ->notEmpty('slug');

        $validator
            ->requirePresence('type', 'create')
            ->notEmpty('type');

        $validator
            ->boolean('is_editable')
            ->requirePresence('is_editable', 'create')
            ->notEmpty('is_editable');

        return $validator;
    }
}
