<?php
namespace Ev3Settings\Model\Table;

use Cake\ORM\Query;
use Cake\ORM\RulesChecker;
use Cake\ORM\Table;
use Cake\Validation\Validator;

/**
 * SettingCategories Model
 *
 * @property \Cake\ORM\Association\HasMany $Settings
 *
 * @method \Ev3Settings\Model\Entity\SettingCategory get($primaryKey, $options = [])
 * @method \Ev3Settings\Model\Entity\SettingCategory newEntity($data = null, array $options = [])
 * @method \Ev3Settings\Model\Entity\SettingCategory[] newEntities(array $data, array $options = [])
 * @method \Ev3Settings\Model\Entity\SettingCategory|bool save(\Cake\Datasource\EntityInterface $entity, $options = [])
 * @method \Ev3Settings\Model\Entity\SettingCategory patchEntity(\Cake\Datasource\EntityInterface $entity, array $data, array $options = [])
 * @method \Ev3Settings\Model\Entity\SettingCategory[] patchEntities($entities, array $data, array $options = [])
 * @method \Ev3Settings\Model\Entity\SettingCategory findOrCreate($search, callable $callback = null)
 *
 * @mixin \Cake\ORM\Behavior\TimestampBehavior
 */
class SettingCategoriesTable extends Table
{

    /**
     * Initialize method
     *
     * @param array $config The configuration for the Table.
     * @return void
     */
    public function initialize(array $config)
    {
        parent::initialize($config);

        $this->table('setting_categories');
        $this->displayField('name');
        $this->primaryKey('id');

        $this->addBehavior('Timestamp');

        $this->hasMany('Settings', [
            'foreignKey' => 'setting_category_id',
            'className' => 'Ev3Settings.Settings'
        ]);
    }

    /**
     * Default validation rules.
     *
     * @param \Cake\Validation\Validator $validator Validator instance.
     * @return \Cake\Validation\Validator
     */
    public function validationDefault(Validator $validator)
    {
        $validator
            ->integer('id')
            ->allowEmpty('id', 'create');

        $validator
            ->requirePresence('name', 'create')
            ->notEmpty('name');

        $validator
            ->requirePresence('slug', 'create')
            ->notEmpty('slug');

        $validator
            ->boolean('is_editable')
            ->requirePresence('is_editable', 'create')
            ->notEmpty('is_editable');

        return $validator;
    }
}
