<?php
namespace Ev3Settings\Controller\Component;

use Cake\Controller\Component;
use Cake\Core\Configure;
use Cake\Utility\Hash;

class SettingsComponent extends Component
{

    /**
     * Initialize component
     *
     * @param array $config Component configuration
     *
     * @return void
     */
    public function initialize(array $config)
    {
        parent::initialize($config);
        $controller = $this->_registry->getController();
        $controller->loadModel('Ev3Settings.Settings');
        // Get all the settings from the database and write to the app's configuration data.
        $settings = $controller->Settings->find('all')
            ->contain('SettingCategories')
            ->order(['SettingCategories.lft' => 'ASC'])
            ->toArray();
        Configure::write(
            'SiteSettings',
            Hash::combine($settings, '{n}.slug', '{n}.value', '{n}.setting_category.slug')
        );
    }
}
