<?php
namespace Ev3Settings\Controller\Admin;

use App\Controller\Admin\AppController;

/**
 * Settings Controller
 *
 * @property \Ev3Settings\Model\Table\SettingsTable $Settings
 */
class SettingsController extends AppController
{
    /**
     * Called before the controller action. You can use this method to configure and customize
     * components or perform logic that needs to happen before each controller action.
     *
     * @param \Cake\Event\Event $event An Event instance
     *
     * @return \Cake\Network\Response|null
     */
    public function beforeFilter(\Cake\Event\Event $event)
    {
        $this->Crud->mapAction('manage', 'Crud.Index');
        $this->Crud->mapAction('add', 'Crud.Add');
        $this->Crud->mapAction('edit', 'Crud.Edit');
        $this->Crud->addListener('relatedModels', 'Crud.RelatedModels');
        parent::beforeFilter($event);
    }

    /**
     * Edit all settings
     *
     * @return \Cake\Network\Response|null
     */
    public function index()
    {
        $settings = $this->Settings->find('all')
            ->contain('SettingCategories')
            ->order(['SettingCategories.lft' => 'ASC'])
            // We need to index by the primary key to ensure we can correctly identify the entities
            // with their form elements (we're going to group the settings for generating the form
            // in a few lines).
            ->indexBy('id');

        if ($this->request->is(['post', 'put'])) {
            $entities = $this->Settings->patchEntities($settings, $this->request->data());
            if ($this->Settings->saveMany($entities) !== false) {
                $this->Flash->success(__d('ev3_settings', 'The settings have been updated'));

                return $this->redirect($this->here);
            } else {
                $this->Flash->error(__d('ev3_settings', 'There was a problem updating your changes'));
            }
        }

        // We want to show the settings grouped by category for the form but need this as a separate
        // variable so as to not lose the entity data required for saving the settings.
        $groupedSettings = $settings->groupBy('setting_category.name');

        // Added breadcrumb.
        $this->Breadcrumb->addCrumb(__d('ev3_settings', 'Settings'));

        $this->set(compact('settings', 'groupedSettings'));
        $this->set('pluralHumanName', 'Settings');
        $this->viewBuilder()->templatePath('Settings');
        $this->viewBuilder()->template('index');
        $this->viewBuilder()->theme('CoreUI');
    }

    /**
     * Manage site settings.
     *
     * @return \Cake\Network\Response
     */
    public function manage()
    {
        $action = $this->Crud->action();
        $action->config('scaffold.fields', ['name', 'slug', 'created', 'modified']);

        $action->config('scaffold.field_settings', [
            $this->Settings->displayField() => [
                'nolink' => true
            ]
        ]);
        $this->viewBuilder()->template('index');

        return $this->Crud->execute();
    }

    /**
     * Set up the add/edit forms.
     *
     * @return void
     */
    protected function _form()
    {
        $action = $this->Crud->action();

        $action->config('scaffold.field_settings', [
            'options' => [
                'type' => 'textarea'
            ]
        ]);
    }
}
