<?php
namespace Ev3Settings\Controller\Admin;

use App\Controller\Admin\AppController;

/**
 * SettingCategories Controller
 *
 * @property \Ev3Settings\Model\Table\SettingCategoriesTable $SettingCategories
 */
class SettingCategoriesController extends AppController
{
    /**
     * Called before the controller action. You can use this method to configure and customize
     * components or perform logic that needs to happen before each controller action.
     *
     * @param \Cake\Event\Event $event An Event instance
     *
     * @return \Cake\Network\Response|null
     */
    public function beforeFilter(\Cake\Event\Event $event)
    {
        $this->Crud->mapAction('index', 'Crud.Index');
        $this->Crud->mapAction('add', 'Crud.Add');
        $this->Crud->mapAction('edit', 'Crud.Edit');
        $this->Crud->mapAction('delete', 'Crud.Delete');
        $this->Crud->mapAction('sort', 'Ev3Crud.Sort');
        parent::beforeFilter($event);
    }

    /**
     * Manage site setting categories.
     *
     * @return \Cake\Network\Response
     */
    public function index()
    {
        $action = $this->Crud->action();
        $action->config('scaffold.fields', ['name', 'slug', 'created', 'modified']);

        $action->config('scaffold.field_settings', [
            $this->SettingCategories->displayField() => [
                'nolink' => true
            ]
        ]);
        $this->viewBuilder()->template('index');

        return $this->Crud->execute();
    }
}
