<?php
namespace Ev3Pages\Controller\Admin;

use App\Controller\Admin\AppController;

class PagesController extends AppController
{

    /**
     * Called before the controller action.
     *
     * @param \Cake\Event\Event $event An Event instance
     *
     * @return \Cake\Network\Response|null
     */
    public function beforeFilter(\Cake\Event\Event $event)
    {
        $this->Crud->mapAction('index', 'Crud.Index');
        $this->Crud->mapAction('add', 'Crud.Add');
        $this->Crud->mapAction('edit', 'Crud.Edit');
        $this->Crud->mapAction('delete', 'Ev3Crud.Delete');
        parent::beforeFilter($event);
    }

    /**
     * Index page
     *
     * @return \Cake\Network\Response
     */
    public function index()
    {
        $action = $this->Crud->action();
        $action->config('scaffold.fields', [
            'id',
            'title',
            'internal_title',
            'is_active',
            'created',
            'modified'
        ]);

        return $this->Crud->execute();
    }

    /**
     * Shared form logic
     *
     * @return void
     */
    protected function _form()
    {
        $action = $this->Crud->action();
        $action->config('scaffold.field_settings', [
            'redirect' => [
                'label' => __d('ev3_pages', 'Redirect URL')
            ]
        ]);
    }

}
