<?php
namespace Ev3Menu\Test\TestCase\View\Helper;

use Cake\Network\Request;
use Cake\ORM\TableRegistry;
use Cake\TestSuite\TestCase;
use Cake\View\Helper;
use Cake\View\View;
use Ev3Menu\Test\Fixture\MenusFixture;
use Ev3Menu\View\Helper\MenuHelper;

/**
 * Ev3Menu\View\Helper\MenuHelper Test Case
 */
class MenuHelperTest extends TestCase
{
    /**
     * Fixtures
     *
     * @var array
     */
    public $fixtures = [
        'plugin.ev3_menu.Menus'
    ];

    public function testMatchUri()
    {
        $MenuHelper = $this->getMockBuilder('Ev3Menu\View\Helper\MenuHelper')
            ->setConstructorArgs([new View(new Request())])
            ->setMethods(['getUri'])
            ->getMock();

        $MenuHelper->expects($this->any())
            ->method('getUri')
            ->will($this->returnValue('/foo'));

        $this->assertTrue($MenuHelper->matchUri('/foo'));
        $this->assertFalse($MenuHelper->matchUri('/bar'));
    }

    public function testMatchRegex()
    {
        $MenuHelper = $this->getMockBuilder('Ev3Menu\View\Helper\MenuHelper')
            ->setConstructorArgs([new View(new Request())])
            ->setMethods(['getUri'])
            ->getMock();

        $MenuHelper->expects($this->any())
            ->method('getUri')
            ->will($this->returnValue('/foo/bar/1'));

        $this->assertTrue($MenuHelper->matchRegex('|^\/foo\/bar\/\d+|'));
        $this->assertFalse($MenuHelper->matchRegex('|^\/bar\/\d+|'));
    }

    public function testCheckActive()
    {
        $MenuHelper = $this->getMockBuilder('Ev3Menu\View\Helper\MenuHelper')
            ->setConstructorArgs([new View(new Request())])
            ->setMethods(['getUri'])
            ->getMock();

        $MenuHelper->expects($this->any())
            ->method('getUri')
            ->will($this->returnValue('/foo/bar/1'));

        $item = [
            'active' => false,
            'route' => '/',
            'pattern' => '|^\/foo\/bar\/\d+|'
        ];
        $this->assertTrue($MenuHelper->checkActive($item));
    }

    public function testBuildMenu()
    {
        $MenuHelper = $this->getMockBuilder('Ev3Menu\View\Helper\MenuHelper')
            ->setConstructorArgs([new View(new Request())])
            ->setMethods(['getUri'])
            ->getMock();

        $MenuHelper->expects($this->any())
            ->method('getUri')
            ->will($this->returnValue('/foo/bar'));

        $menu = TableRegistry::get('Ev3Menu.Menus')->getMenu(1);
        $activeParent = false;
        $result = $MenuHelper->buildMenu($menu, $activeParent);
        $this->assertCount(3, $result);
        // Check that the correct items are being flagged as active.
        $this->assertFalse($result[0]['active']);
        $this->assertTrue($result[2]['active']);
    }
}
