<?php
namespace Ev3Menu\Test\TestCase\Model\Table;

use Cake\ORM\TableRegistry;
use Cake\TestSuite\TestCase;
use Ev3Menu\Model\Table\MenusTable;

/**
 * Ev3Menu\Model\Table\MenusTable Test Case
 */
class MenusTableTest extends TestCase
{

    /**
     * Fixtures
     *
     * @var array
     */
    public $fixtures = [
        'plugin.ev3_menu.menus'
    ];

    /**
     * setUp method
     *
     * @return void
     */
    public function setUp()
    {
        parent::setUp();
        $config = TableRegistry::exists('Menus') ? [] : ['className' => 'Ev3Menu\Model\Table\MenusTable'];
        $this->Menus = TableRegistry::get('Menus', $config);
    }

    /**
     * tearDown method
     *
     * @return void
     */
    public function tearDown()
    {
        unset($this->Menus);

        parent::tearDown();
    }

    /**
     * Test getMenu method
     *
     * @return void
     */
    public function testGetMenu()
    {
        $result = $this->Menus->getMenu(1);
        // Check that the method returns an array.
        $this->assertInternalType('array', $result);
        // Check that the method returns the expected number of results.
        $this->assertCount(3, $result);
    }
}
