<?php
namespace Ev3Menu\Test\Fixture;

use Cake\TestSuite\Fixture\TestFixture;

/**
 * MenusFixture
 *
 */
class MenusFixture extends TestFixture
{

    /**
     * Table name
     *
     * @var string
     */
    public $table = 'menus';

    /**
     * Fields
     *
     * @var array
     */
    // @codingStandardsIgnoreStart
    public $fields = [
        'id' => ['type' => 'integer', 'length' => 11, 'unsigned' => false, 'null' => false, 'default' => null, 'comment' => '', 'autoIncrement' => true, 'precision' => null],
        'parent_id' => ['type' => 'integer', 'length' => 11, 'unsigned' => false, 'null' => true, 'default' => null, 'comment' => '', 'precision' => null, 'autoIncrement' => null],
        'lft' => ['type' => 'integer', 'length' => 11, 'unsigned' => false, 'null' => false, 'default' => null, 'comment' => '', 'precision' => null, 'autoIncrement' => null],
        'rght' => ['type' => 'integer', 'length' => 11, 'unsigned' => false, 'null' => false, 'default' => null, 'comment' => '', 'precision' => null, 'autoIncrement' => null],
        'name' => ['type' => 'string', 'length' => 45, 'null' => false, 'default' => null, 'comment' => '', 'precision' => null, 'fixed' => null],
        'url' => ['type' => 'string', 'length' => 255, 'null' => true, 'default' => null, 'comment' => '', 'precision' => null, 'fixed' => null],
        'pattern' => ['type' => 'string', 'length' => 1024, 'null' => true, 'default' => null, 'comment' => '', 'precision' => null, 'fixed' => null],
        'plugin' => ['type' => 'string', 'length' => 45, 'null' => true, 'default' => null, 'comment' => '', 'precision' => null, 'fixed' => null],
        'controller' => ['type' => 'string', 'length' => 45, 'null' => true, 'default' => null, 'comment' => '', 'precision' => null, 'fixed' => null],
        'action' => ['type' => 'string', 'length' => 45, 'null' => true, 'default' => null, 'comment' => '', 'precision' => null, 'fixed' => null],
        'foreign_key' => ['type' => 'integer', 'length' => 11, 'unsigned' => false, 'null' => true, 'default' => null, 'comment' => '', 'precision' => null, 'autoIncrement' => null],
        'class' => ['type' => 'string', 'length' => 45, 'null' => true, 'default' => null, 'comment' => '', 'precision' => null, 'fixed' => null],
        'content_element' => ['type' => 'string', 'length' => 255, 'null' => true, 'default' => null, 'comment' => '', 'precision' => null, 'fixed' => null],
        'new_window' => ['type' => 'boolean', 'length' => null, 'null' => false, 'default' => '0', 'comment' => '', 'precision' => null],
        'is_hidden' => ['type' => 'boolean', 'length' => null, 'null' => false, 'default' => '0', 'comment' => '', 'precision' => null],
        'is_active' => ['type' => 'boolean', 'length' => null, 'null' => false, 'default' => '1', 'comment' => '', 'precision' => null],
        'created' => ['type' => 'datetime', 'length' => null, 'null' => false, 'default' => null, 'comment' => '', 'precision' => null],
        'modified' => ['type' => 'datetime', 'length' => null, 'null' => false, 'default' => null, 'comment' => '', 'precision' => null],
        '_constraints' => [
            'primary' => ['type' => 'primary', 'columns' => ['id'], 'length' => []],
        ],
        '_options' => [
            'engine' => 'InnoDB',
            'collation' => 'utf8_general_ci'
        ],
    ];
    // @codingStandardsIgnoreEnd

    /**
     * Records
     *
     * @var array
     */
    public $records = [
        [
            'id' => 1,
            'parent_id' => null,
            'lft' => 0,
            'rght' => 9,
            'name' => 'Menu',
            'url' => null,
            'pattern' => null,
            'plugin' => null,
            'controller' => null,
            'action' => null,
            'foreign_key' => null,
            'class' => null,
            'content_element' => null,
            'new_window' => 0,
            'is_hidden' => 1,
            'is_active' => 1,
            'created' => '2016-02-11 15:55:41',
            'modified' => '2016-02-11 15:55:41'
        ],
        [
            'id' => 2,
            'parent_id' => 1,
            'lft' => 1,
            'rght' => 2,
            'name' => 'Menu Item 1',
            'url' => '/',
            'pattern' => null,
            'plugin' => null,
            'controller' => null,
            'action' => null,
            'foreign_key' => null,
            'class' => null,
            'content_element' => null,
            'new_window' => 0,
            'is_hidden' => 0,
            'is_active' => 1,
            'created' => '2016-02-11 15:55:41',
            'modified' => '2016-02-11 15:55:41'
        ],
        [
            'id' => 3,
            'parent_id' => 1,
            'lft' => 3,
            'rght' => 8,
            'name' => 'Menu Item 2',
            'url' => '/foo',
            'pattern' => null,
            'plugin' => null,
            'controller' => null,
            'action' => null,
            'foreign_key' => null,
            'class' => null,
            'content_element' => null,
            'new_window' => 0,
            'is_hidden' => 0,
            'is_active' => 1,
            'created' => '2016-02-11 15:55:41',
            'modified' => '2016-02-11 15:55:41'
        ],
        [
            'id' => 4,
            'parent_id' => null,
            'lft' => 4,
            'rght' => 5,
            'name' => 'Child Menu Item 1',
            'url' => null,
            'pattern' => null,
            'plugin' => null,
            'controller' => 'foo',
            'action' => 'bar',
            'foreign_key' => null,
            'class' => null,
            'content_element' => null,
            'new_window' => 0,
            'is_hidden' => 0,
            'is_active' => 1,
            'created' => '2016-02-11 15:55:41',
            'modified' => '2016-02-11 15:55:41'
        ],
        [
            'id' => 5,
            'parent_id' => null,
            'lft' => 6,
            'rght' => 7,
            'name' => 'Child Menu Item 2',
            'url' => null,
            'pattern' => null,
            'plugin' => null,
            'controller' => null,
            'action' => null,
            'foreign_key' => null,
            'class' => null,
            'content_element' => null,
            'new_window' => 0,
            'is_hidden' => 0,
            'is_active' => 0,
            'created' => '2016-02-11 15:55:41',
            'modified' => '2016-02-11 15:55:41'
        ],
    ];
}
