<?php
namespace Ev3Menu\Model\Entity;

use Cake\ORM\Entity;
use Cake\Routing\Router;

/**
 * Menu Entity.
 *
 * @property int $id
 * @property int $parent_id
 * @property \Ev3Menu\Model\Entity\ParentMenu $parent_menu
 * @property int $lft
 * @property int $rght
 * @property string $name
 * @property string $url
 * @property string $pattern
 * @property string $plugin
 * @property string $controller
 * @property string $action
 * @property int $foreign_key
 * @property string $content_element
 * @property bool $new_window
 * @property bool $is_hidden
 * @property bool $is_active
 * @property \Cake\I18n\Time $created
 * @property \Cake\I18n\Time $modified
 * @property \Ev3Menu\Model\Entity\ChildMenu[] $child_menus
 */
class Menu extends Entity
{

    /**
     * Fields that can be mass assigned using newEntity() or patchEntity().
     *
     * Note that when '*' is set to true, this allows all unspecified fields to
     * be mass assigned. For security purposes, it is advised to set '*' to false
     * (or remove it), and explicitly make individual fields accessible as needed.
     *
     * @var array
     */
    protected $_accessible = [
        '*' => true,
        'id' => false,
    ];

    /**
     * Define the route. This is to be used for link a menu item to a page.
     *
     * @return string URI
     */
    protected function _getRoute()
    {
        if (!empty($this->_properties['url'])) {
            return $this->_properties['url'];

        } elseif (!empty($this->_properties['controller'])) {
            $route = [
                'controller' => $this->_properties['controller'],
                'action' => $this->_properties['action'],
                'plugin' => $this->_properties['plugin']
            ];
            if (!empty($this->_properties['foreign_key'])) {
                $route += (array)$this->_properties['foreign_key'];
            }

            return Router::url($route);
        }

        return null;
    }
}
