<?php
namespace Ev3Menu\Controller\Admin;

use App\Controller\Admin\AppController;

/**
 * Menus Controller
 *
 * @property \Ev3Menu\Model\Table\MenusTable $Menus
 */
class MenusController extends AppController
{
    /**
     * Before filter.
     *
     * @param \Cake\Event\Event $event An Event instance
     *
     * @return \Cake\Network\Response|null
     */
    public function beforeFilter(\Cake\Event\Event $event)
    {
        $this->Crud->mapAction('index', 'Ev3Crud.Sort');
        $this->Crud->mapAction('add', 'Crud.Add');
        $this->Crud->mapAction('edit', 'Crud.Edit');
        $this->Crud->mapAction('delete', 'Ev3Crud.Delete');
        parent::beforeFilter($event);
    }

    /**
     * Menu index.
     *
     * @return \Cake\Network\Response
     */
    public function index()
    {
        // Ensure that we use the sort template as we deliver a sortable index of the menu by
        // default rather than a table of menu entities.
        $this->viewBuilder()->template('sort');

        return $this->Crud->execute();
    }

    /**
     * Set up the add/edit forms.
     *
     * @return void
     */
    protected function _form()
    {
        $action = $this->Crud->action();
        $action->config('scaffold.fields_blacklist', ['lft', 'rght', 'controller', 'action', 'foreign_key', 'plugin', 'created', 'modified']);

        $action->config('scaffold.field_settings', [
            'parent_id' => [
                'empty' => __d('ev3_menu', 'Please select')
            ],
            'url' => [
                'label' => __d('ev3_menu', 'URL')
            ]
        ]);

        $parents = $this->Menus->find('list');
        $this->set(compact('parents'));
    }
}
