<?php
namespace Ev3Mailer\Mailer;

use BadMethodCallException;
use Cake\Log\Log;

class Email extends \Cake\Mailer\Email
{
    /**
     * What format should the email be sent in - we're overriding the default to be 'HTML' rather
     * than 'text'.
     *
     * @var string
     */
    protected $_emailFormat = 'html';

    /**
     * Test email address - when populated all outgoing emails will be sent to this address,
     * overriding whatever is passed to `Email`.
     *
     * @var string
     */
    protected $_testEmail = null;

    /**
     * Constructor
     *
     * @param array|string|null $config Array of configs, or string to load configs from email.php
     */
    public function __construct($config = null)
    {
        if ($config === null) {
            $config = 'default';
        }
        parent::__construct($config);

        // Check if a testEmail address has been set for use with the mailer.
        if (is_string($config)) {
            $config = static::config($config);
        }
        if (!empty($config['testEmail'])) {
            $this->testMode($config['testEmail']);
        }
    }

    /**
     * To
     *
     * @param string|array|null $email Null to get, String with email,
     *   Array with email as key, name as value or email as value (without name)
     * @param string|null $name Name
     * @return array|$this
     */
    public function to($email = null, $name = null)
    {
        if ($email !== null && $this->_testEmail) {
            $email = $this->_testEmail;
        }

        return parent::to($email, $name);
    }

    /**
     * Add To
     *
     * @param string|array $email Null to get, String with email,
     *   Array with email as key, name as value or email as value (without name)
     * @param string|null $name Name
     * @return $this
     */
    public function addTo($email, $name = null)
    {
        if ($email !== null && $this->_testEmail) {
            $email = $this->_testEmail;
        }

        return parent::addTo($email, $name);
    }

    /**
     * Cc
     *
     * @param string|array|null $email Null to get, String with email,
     *   Array with email as key, name as value or email as value (without name)
     * @param string|null $name Name
     * @return array|$this
     */
    public function cc($email = null, $name = null)
    {
        if ($email !== null && $this->_testEmail) {
            $email = $this->_testEmail;
        }

        return parent::cc($email, $name);
    }

    /**
     * Add Cc
     *
     * @param string|array $email Null to get, String with email,
     *   Array with email as key, name as value or email as value (without name)
     * @param string|null $name Name
     * @return $this
     */
    public function addCc($email, $name = null)
    {
        if ($email !== null && $this->_testEmail) {
            $email = $this->_testEmail;
        }

        return parent::addCc($email, $name);
    }

    /**
     * Bcc
     *
     * @param string|array|null $email Null to get, String with email,
     *   Array with email as key, name as value or email as value (without name)
     * @param string|null $name Name
     * @return array|$this
     */
    public function bcc($email = null, $name = null)
    {
        if ($email !== null && $this->_testEmail) {
            $email = $this->_testEmail;
        }

        return parent::bcc($email, $name);
    }

    /**
     * Add Bcc
     *
     * @param string|array $email Null to get, String with email,
     *   Array with email as key, name as value or email as value (without name)
     * @param string|null $name Name
     * @return $this
     */
    public function addBcc($email, $name = null)
    {
        if ($email !== null && $this->_testEmail) {
            $email = $this->_testEmail;
        }

        return parent::addBcc($email, $name);
    }

    /**
     * Send an email using the specified content, template and layout
     *
     * @param string|array|null $content String with message or array with messages
     * @return array
     * @throws \BadMethodCallException
     */
    public function send($content = null)
    {
        try {
            return parent::send($content);
        } catch (BadMethodCallException $e) {
            Log::write('error', $e);

            return false;
        }
    }

    /**
     * Static method to fast create an instance of \Cake\Mailer\Email
     *
     * @param string|array|null $to Address to send (see Cake\Mailer\Email::to()). If null, will try to use 'to' from transport config
     * @param string|null $subject String of subject or null to use 'subject' from transport config
     * @param string|array|null $message String with message or array with variables to be used in render
     * @param string|array $transportConfig String to use config from EmailConfig or array with configs
     * @param bool $send Send the email or just return the instance pre-configured
     * @return static Instance of Cake\Mailer\Email
     * @throws \InvalidArgumentException
     */
    public static function deliver($to = null, $subject = null, $message = null, $transportConfig = 'default', $send = true)
    {
        if ($to !== null && $testEmail) {
            $to = $testEmail;
        }

        return parent::deliver($to, $subject, $message, $transportConfig, $send);
    }

    /**
     * Enable test mode so that all emails get sent to the defined email address.
     *
     * @param string|bool $email Email address to send test emails to or false to use production mode
     * @return void
     */
    public function testMode($email = false)
    {
        $this->_testEmail = $email;
    }

    /**
     * Category
     *
     * Helps to distinguish between sites when viewing on Sendgrid by making use of the X-SMTPAPI
     * functionality.
     *
     * @param string $category Contains the category name
     * @return void
     */
    public function category($category = null)
    {
        if ($category) {
            $data = ['category' => $category];
            $this->addHeaders(['x-smtpapi' => json_encode($data)]);
        }

        return $this;
    }
}
