<?php
namespace Ev3Inflector\View\Helper;

use Cake\View\Helper;
use Cake\View\View;

/**
 * Inflector helper
 */
class InflectorHelper extends Helper
{

    /**
     * Default configuration.
     *
     * @var array
     */
    protected $_defaultConfig = [];

    /**
     * Magic method to check if the function exists in the Inflector class and call it if it does.
     * Otherwise, it will try and return the string we were trying to inflect or return false if
     * that fails.
     * @param string $name Method name
     * @param mixed $arguments Method arguments
     * @return string|bool Inflected string
     */
    public function __call($name, $arguments)
    {
        if (method_exists('Ev3Inflector\Utility\Inflector', $name)) {
            return call_user_func_array('Ev3Inflector\Utility\Inflector::' . $name, $arguments);
        } else {
            // Method `$name` could not be found, try and return the string (it should, in almost
            // every case, be the first argument).
            if (!empty($arguments) && is_array($arguments)) {
                return array_shift($arguments);
            }
        }

        return false;
    }
}
