<?php
namespace Ev3Inflector\Utility;

class Inflector extends \Cake\Utility\Inflector
{

    /**
     * Title case exception words that should not be uppercased.
     *
     * @var array
     */
    protected static $_titleCaseExceptions = [
        'a',
        'and',
        'but',
        'or',
        'for',
        'nor',
        'the',
        'on',
        'at',
        'to',
        'from',
        'by',
        'of'
    ];

    /**
     * Converts a string to Title Case.
     *
     * @param string $string String to convert to title case
     *
     * @return Title cased string
     */
    public static function titleCase($string)
    {
        $words = explode(' ', $string);
        foreach ($words as &$word) {
            $word = strtolower($word);
            if (!in_array($word, static::$_titleCaseExceptions)) {
                $word = ucfirst($word);
            }
        }

        return implode(' ', $words);
    }
}
