Ev3Img
======

This plugin provides an `ImgHelper` for resizing and manipulating images using either Imagick or GD.

Installation
------------

You can install this plugin into your CakePHP application using [composer](http://getcomposer.org).

The recommended way to install composer packages is:

    composer require ev3/img

Then add the following line to your bootstrap.php to load the plugin (unless you are using `CakePlugin::loadAll()`).

    CakePlugin::load('EvImg');

Usage
-----

To output an `<img>` tag with resized image use the `resize()` method passing either an image path or image object as the first parameter:-

    <?= $this->Img->resize($image, ['width' => 400, 'height' => 300], ['class' => 'full']); ?>

The second parameter is an array of image dimensions and manipulation rules.

The third parameter is any tag attributes you want applying to the `<img>` tag and/or a `url` attribute to link the image.

There is an optional fourth attribute for passing the image context. This is a string that defines the directory the resized image is to be cached to. This defaults to `$image->id` when passing an image array as the first parameter.

You can retrieve just the image path using `path()`:-

    <?= $this->Img->path($image, ['width' => 400, 'height' => 300]); ?>

The image dimensions are deliberately kept in a separate array to the attributes so that you can define image dimensions elsewhere in your app for consistency. For example, you could define `$thumbnail` in your AppController and then use it like:-

    <?= $this->Img->resize($image, $thumbnail, ['class' => 'full']); ?>

The dimensions options are:-

 * `(int)width` - image width
 * `(int)height` - image height
 * `(bool)fit` - fits the image to defined `width` and `height`
 * `(bool)crop` - crops the image to defined `width` and `height`
 * `(bool)greyscale` - converts the image to greyscale

If you only define one of `width` or `height` it will scale the image according to that, otherwise it will scale to which ever is closest to the image's ratio (unless `fit` or `crop` are defined).
