<?php
namespace Ev3Crud\Listener;

use Crud\Listener\BaseListener;
use Cake\Event\Event;

class ViewListener extends BaseListener
{
    /**
     * beforeFind event.
     * @param \Cake\Event\Event $event Event
     * @return void
     */
    public function beforeFind(Event $event)
    {
        $this->_isVisible($event);
    }
    /**
     * afterFind event.
     * @param \Cake\Event\Event $event Event
     * @return void
     */
    public function afterFind(Event $event)
    {
        $this->_redirect($event);
    }

    /**
     * beforePaginate event.
     * @param \Cake\Event\Event $event Event
     * @return void
     */
    public function beforePaginate(Event $event)
    {
        $this->_isVisible($event);
    }

    /**
     * Add conditions to check that the content is flagged as active.
     * @param \Cake\Event\Event $event Event
     * @return void
     */
    protected function _isVisible(Event $event)
    {
        $table = $this->_table();
        // We only want to return items flagged as `is_active` if this field exists.
        if ($table->hasField('is_active')) {
            $event->subject()->query->where(['is_active' => true]);
        }
        // We also need to check for soft deleted content.
        if ($table->hasField('is_removed')) {
            $event->subject()->query->where(['is_removed' => false]);
        }
    }

    /**
     * Check if we need to redirect.
     *
     * @param \Cake\Event\Event $event Event
     *
     * @return void
     */
    protected function _redirect(Event $event)
    {
        $table = $this->_table();
        if ($table->hasField('redirect') && !empty($event->subject()->entity->redirect)) {
            $this->_controller()->redirect($event->subject()->entity->redirect, 301);
        }
    }
}
